/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.ModuleInfoRequiresBlueprint;
import java.util.Objects;
import java.util.Optional;

public interface ModuleInfoRequires
extends ModuleInfoRequiresBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleInfoRequires instance) {
        return (Builder)ModuleInfoRequires.builder().from(instance);
    }

    public static ModuleInfoRequires create() {
        return ModuleInfoRequires.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ModuleInfoRequires>
    implements io.helidon.common.Builder<Builder, ModuleInfoRequires> {
        private Builder() {
        }

        public ModuleInfoRequires buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleInfoRequiresImpl(this);
        }

        public ModuleInfoRequires build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ModuleInfoRequires>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean isStatic;
        private boolean isTransitive;
        private String dependency;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleInfoRequires prototype) {
            this.isStatic(prototype.isStatic());
            this.isTransitive(prototype.isTransitive());
            this.dependency(prototype.dependency());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.isStatic(builder.isStatic());
            this.isTransitive(builder.isTransitive());
            builder.dependency().ifPresent(this::dependency);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER isTransitive(boolean isTransitive) {
            this.isTransitive = isTransitive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependency(String dependency) {
            Objects.requireNonNull(dependency);
            this.dependency = dependency;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isTransitive() {
            return this.isTransitive;
        }

        public Optional<String> dependency() {
            return Optional.ofNullable(this.dependency);
        }

        public String toString() {
            return "ModuleInfoRequiresBuilder{isStatic=" + this.isStatic + ",isTransitive=" + this.isTransitive + ",dependency=" + this.dependency + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.dependency == null) {
                collector.fatal(this.getClass(), "Property \"dependency\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ModuleInfoRequiresImpl
        implements ModuleInfoRequires {
            private final boolean isStatic;
            private final boolean isTransitive;
            private final String dependency;

            protected ModuleInfoRequiresImpl(BuilderBase<?, ?> builder) {
                this.isStatic = builder.isStatic();
                this.isTransitive = builder.isTransitive();
                this.dependency = builder.dependency().get();
            }

            @Override
            public boolean isStatic() {
                return this.isStatic;
            }

            @Override
            public boolean isTransitive() {
                return this.isTransitive;
            }

            @Override
            public String dependency() {
                return this.dependency;
            }

            public String toString() {
                return "ModuleInfoRequires{isStatic=" + this.isStatic + ",isTransitive=" + this.isTransitive + ",dependency=" + this.dependency + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleInfoRequires)) {
                    return false;
                }
                ModuleInfoRequires other = (ModuleInfoRequires)o;
                return this.isStatic == other.isStatic() && this.isTransitive == other.isTransitive() && Objects.equals(this.dependency, other.dependency());
            }

            public int hashCode() {
                return Objects.hash(this.isStatic, this.isTransitive, this.dependency);
            }
        }
    }
}

