/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.Bytes48;
import org.hyperledger.besu.ethereum.rlp.AbstractRLPInput;

public class BytesValueRLPInput
extends AbstractRLPInput {
    private final Bytes value;

    public BytesValueRLPInput(Bytes value, boolean lenient) {
        this(value, lenient, true);
    }

    public BytesValueRLPInput(Bytes value, boolean lenient, boolean shouldFitExactly) {
        super(lenient);
        this.value = value;
        this.init(value.size(), shouldFitExactly);
    }

    @Override
    protected byte inputByte(long offset) {
        return this.value.get((int)offset);
    }

    @Override
    protected Bytes inputSlice(long offset, int length) {
        return this.value.slice(Math.toIntExact(offset), length);
    }

    @Override
    protected Bytes32 inputSlice32(long offset) {
        return Bytes32.wrap((Bytes)this.inputSlice(offset, 32));
    }

    @Override
    protected Bytes48 inputSlice48(long offset) {
        return Bytes48.wrap((Bytes)this.inputSlice(offset, 48));
    }

    @Override
    protected String inputHex(long offset, int length) {
        return this.value.slice(Math.toIntExact(offset), length).toString().substring(2);
    }

    @Override
    protected BigInteger getUnsignedBigInteger(long offset, int length) {
        return this.value.slice(Math.toIntExact(offset), length).toUnsignedBigInteger();
    }

    @Override
    protected int getInt(long offset) {
        return this.value.getInt(Math.toIntExact(offset));
    }

    @Override
    protected long getLong(long offset) {
        return this.value.getLong(Math.toIntExact(offset));
    }

    @Override
    public Bytes raw() {
        return this.value;
    }
}

