/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.consensus.ConsensusCreateTopicTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.CalculatorState;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculatorImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ConsensusCreateTopicFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable CalculatorState calculatorState, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        long keys = 0L;
        ConsensusCreateTopicTransactionBody op = txnBody.consensusCreateTopicOrThrow();
        if (op.hasAdminKey()) {
            keys += SimpleFeeCalculatorImpl.countKeys((Key)op.adminKey());
        }
        if (op.hasFeeScheduleKey()) {
            keys += SimpleFeeCalculatorImpl.countKeys((Key)op.feeScheduleKey());
        }
        if (op.hasSubmitKey()) {
            keys += SimpleFeeCalculatorImpl.countKeys((Key)op.submitKey());
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONSENSUS_CREATE_TOPIC);
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC;
    }
}

