/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCallOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.worldstate.CodeDelegationGasCostHelper;

public abstract class AbstractExtCallOperation
extends AbstractCallOperation {
    static final int STACK_TO = 0;
    static final int STACK_INPUT_OFFSET = 1;
    static final int STACK_INPUT_LENGTH = 2;
    public static final Bytes EOF1_SUCCESS_STACK_ITEM = Bytes.EMPTY;
    public static final Bytes EOF1_EXCEPTION_STACK_ITEM = BYTES_ONE;
    public static final Bytes EOF1_FAILURE_STACK_ITEM = Bytes.of((int[])new int[]{2});

    AbstractExtCallOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
    }

    @Override
    protected Address to(MessageFrame frame) {
        return Words.toAddress(frame.getStackItem(0));
    }

    @Override
    protected long gas(MessageFrame frame) {
        return Long.MAX_VALUE;
    }

    @Override
    protected long outputDataOffset(MessageFrame frame) {
        return 0L;
    }

    @Override
    protected long outputDataLength(MessageFrame frame) {
        return 0L;
    }

    @Override
    public long gasAvailableForChildCall(MessageFrame frame) {
        throw new UnsupportedOperationException("EXTCALL does not use gasAvailableForChildCall");
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Wei balance;
        Code callingCode = frame.getCode();
        if (callingCode.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        Bytes toBytes = frame.getStackItem(0).trimLeadingZeros();
        Wei value = this.value(frame);
        boolean zeroValue = value.isZero();
        long inputOffset = this.inputDataOffset(frame);
        long inputLength = this.inputDataLength(frame);
        GasCalculator gasCalculator = this.gasCalculator();
        if (!zeroValue && this.isStatic(frame)) {
            return new Operation.OperationResult(gasCalculator.callValueTransferGasCost(), ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (toBytes.size() > 20) {
            return new Operation.OperationResult(Words.clampedAdd(Words.clampedAdd(gasCalculator.memoryExpansionGasCost(frame, inputOffset, inputLength), zeroValue ? 0L : gasCalculator.callValueTransferGasCost()), gasCalculator.getColdAccountAccessCost()), ExceptionalHaltReason.ADDRESS_OUT_OF_RANGE);
        }
        Address to = Words.toAddress(toBytes);
        Account contract = frame.getWorldUpdater().get(to);
        if (contract != null && contract.hasDelegatedCode()) {
            if (contract.getCodeDelegationTargetCode().isEmpty()) {
                throw new RuntimeException("A delegated code account must have delegated code");
            }
            if (contract.getCodeDelegationTargetHash().isEmpty()) {
                throw new RuntimeException("A delegated code account must have a delegated code hash");
            }
            long codeDelegationResolutionGas = CodeDelegationGasCostHelper.codeDelegationGasCost(frame, this.gasCalculator(), contract);
            if (frame.getRemainingGas() < codeDelegationResolutionGas) {
                return new Operation.OperationResult(codeDelegationResolutionGas, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            frame.decrementRemainingGas(codeDelegationResolutionGas);
        }
        boolean accountCreation = (contract == null || contract.isEmpty()) && !zeroValue;
        long cost = Words.clampedAdd(Words.clampedAdd(Words.clampedAdd(gasCalculator.memoryExpansionGasCost(frame, inputOffset, inputLength), zeroValue ? 0L : gasCalculator.callValueTransferGasCost()), frame.warmUpAddress(to) || gasCalculator.isPrecompile(to) ? gasCalculator.getWarmStorageReadCost() : gasCalculator.getColdAccountAccessCost()), accountCreation ? gasCalculator.newAccountGasCost() : 0L);
        long currentGas = frame.getRemainingGas();
        if (currentGas < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        currentGas -= cost;
        frame.expandMemory(inputOffset, inputLength);
        Code code = AbstractExtCallOperation.getCode(evm, contract);
        if (!code.isValid()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INVALID_CODE, 0);
        }
        frame.clearReturnData();
        if (this.isDelegate() && callingCode.getEofVersion() != code.getEofVersion()) {
            return this.softFailure(frame, cost);
        }
        long retainedGas = Math.max(currentGas / 64L, gasCalculator.getMinRetainedGas());
        long childGas = currentGas - retainedGas;
        Account account = frame.getWorldUpdater().get(frame.getRecipientAddress());
        Wei wei = balance = zeroValue || account == null ? Wei.ZERO : account.getBalance();
        if (childGas < gasCalculator.getMinCalleeGas()) {
            return this.softFailure(frame, cost);
        }
        if (!zeroValue && value.compareTo((Bytes)balance) > 0) {
            return this.softFailure(frame, cost);
        }
        if (frame.getDepth() >= 1024) {
            return this.softFailure(frame, cost);
        }
        MutableBytes inputData = frame.readMutableMemory(inputOffset, inputLength);
        MessageFrame.builder().parentMessageFrame(frame).type(MessageFrame.Type.MESSAGE_CALL).initialGas(childGas).address(this.address(frame)).contract(to).inputData((Bytes)inputData).sender(this.sender(frame)).value(this.value(frame)).apparentValue(this.apparentValue(frame)).code(code).isStatic(this.isStatic(frame)).completer(child -> this.complete(frame, (MessageFrame)child)).build();
        frame.setState(MessageFrame.State.CODE_SUSPENDED);
        return new Operation.OperationResult(Words.clampedAdd(cost, childGas), null, 0);
    }

    @Nonnull
    private Operation.OperationResult softFailure(MessageFrame frame, long cost) {
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem(EOF1_EXCEPTION_STACK_ITEM);
        return new Operation.OperationResult(cost, null);
    }

    @Override
    Bytes getCallResultStackItem(MessageFrame childFrame) {
        return switch (childFrame.getState()) {
            case MessageFrame.State.COMPLETED_SUCCESS -> EOF1_SUCCESS_STACK_ITEM;
            case MessageFrame.State.EXCEPTIONAL_HALT -> EOF1_EXCEPTION_STACK_ITEM;
            case MessageFrame.State.COMPLETED_FAILED -> {
                if (childFrame.getExceptionalHaltReason().isPresent()) {
                    yield EOF1_FAILURE_STACK_ITEM;
                }
                yield EOF1_EXCEPTION_STACK_ITEM;
            }
            default -> EOF1_FAILURE_STACK_ITEM;
        };
    }
}

