/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.common.config.GlobalConfig;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.MetaConfig;
import io.helidon.config.MetaConfigFinder;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.service.registry.Service;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Weight(value=90.0)
@Service.Singleton
class ConfigProvider
implements Supplier<Config> {
    private final Config config;

    @Service.Inject
    ConfigProvider(Supplier<Optional<MetaConfig>> metaConfigSupplier, Supplier<List<ConfigSource>> configSources, Supplier<List<ConfigParser>> configParsers, Supplier<List<ConfigFilter>> configFilters, Supplier<List<ConfigMapperProvider>> configMappers) {
        if (GlobalConfig.configured()) {
            this.config = ConfigProvider.wrapCommon(GlobalConfig.config());
        } else {
            Optional<MetaConfig> metaConfig = metaConfigSupplier.get();
            this.config = ((Config.Builder)((Config.Builder)((Config.Builder)((Config.Builder)((Config.Builder)((Config.Builder)Config.builder().update(it -> metaConfig.ifPresent(metaConfigInstance -> it.config(metaConfigInstance.metaConfiguration())))).update(it -> ((List)configSources.get()).forEach(it::addSource))).update(it -> {
                if (metaConfig.isEmpty()) {
                    this.defaultConfigSources((Config.Builder)it, configParsers);
                }
            })).disableParserServices().update(it -> ((List)configParsers.get()).forEach(it::addParser))).disableFilterServices().update(it -> ((List)configFilters.get()).forEach(it::addFilter))).update(it -> ((List)configMappers.get()).forEach(it::addMapper))).build();
        }
    }

    @Override
    public Config get() {
        return this.config;
    }

    static Config wrapCommon(io.helidon.common.config.Config config) {
        if (config instanceof Config) {
            Config cfg = (Config)config;
            return cfg;
        }
        return new CommonConfigWrapper(Config.empty(), config);
    }

    private void defaultConfigSources(Config.Builder configBuilder, Supplier<List<ConfigParser>> configParsers) {
        Set supportedSuffixes = configParsers.get().stream().map(ConfigParser::supportedSuffixes).flatMap(Collection::stream).collect(Collectors.toSet());
        MetaConfigFinder.profile().ifPresent(profile -> MetaConfigFinder.configSources(new ArrayList<String>(supportedSuffixes), profile).forEach(configBuilder::addSource));
        MetaConfigFinder.configSources(new ArrayList<String>(supportedSuffixes)).forEach(configBuilder::addSource);
    }

    private static class CommonConfigWrapper
    implements Config {
        private final Config emptyConfig;
        private final Instant timestamp;
        private final io.helidon.common.config.Config delegate;

        private CommonConfigWrapper(Config realConfig, io.helidon.common.config.Config delegate) {
            this(realConfig, Instant.now(), delegate);
        }

        private CommonConfigWrapper(Config realConfig, Instant timestamp, io.helidon.common.config.Config delegate) {
            this.emptyConfig = realConfig;
            this.delegate = delegate;
            this.timestamp = timestamp;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public Config.Key key() {
            return new CommonKeyWrapper(this.delegate.key());
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public Config get(String key) {
            return new CommonConfigWrapper(this.emptyConfig, this.timestamp, this.delegate.get(key));
        }

        @Override
        public Config root() {
            return new CommonConfigWrapper(this.emptyConfig, this.timestamp, this.delegate.root());
        }

        @Override
        public Config get(Config.Key key) {
            return new CommonConfigWrapper(this.emptyConfig, this.timestamp, this.delegate.get((Config.Key)key));
        }

        @Override
        public Config detach() {
            return new CommonConfigWrapper(this.emptyConfig, this.timestamp, this.delegate.detach());
        }

        @Override
        public Config.Type type() {
            if (this.delegate.isList()) {
                return Config.Type.LIST;
            }
            if (this.delegate.isObject()) {
                return Config.Type.OBJECT;
            }
            if (this.delegate.exists()) {
                return Config.Type.VALUE;
            }
            return Config.Type.MISSING;
        }

        @Override
        public boolean exists() {
            return this.delegate.exists();
        }

        @Override
        public boolean isLeaf() {
            return this.delegate.isLeaf();
        }

        @Override
        public boolean isObject() {
            return this.delegate.isObject();
        }

        @Override
        public boolean isList() {
            return this.delegate.isList();
        }

        @Override
        public boolean hasValue() {
            return this.delegate.hasValue();
        }

        @Override
        public void ifExists(Consumer<Config> action) {
            if (this.delegate.exists()) {
                action.accept(this);
            }
        }

        @Override
        public Stream<Config> traverse() {
            return this.delegate.asList(io.helidon.common.config.Config.class).stream().flatMap(Collection::stream).map((? super T it) -> new CommonConfigWrapper(this.emptyConfig, this.timestamp, (io.helidon.common.config.Config)it));
        }

        @Override
        public Stream<Config> traverse(Predicate<Config> predicate) {
            return this.traverse().filter(predicate);
        }

        @Override
        public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
            return this.emptyConfig.convert(type, value);
        }

        @Override
        public ConfigMapper mapper() {
            return this.emptyConfig.mapper();
        }

        @Override
        public ConfigValue<String> asString() {
            io.helidon.common.config.ConfigValue commonValue = this.delegate.asString();
            if (commonValue.isPresent()) {
                return ConfigValues.create((Config)this, () -> ((io.helidon.common.config.ConfigValue)commonValue).asOptional(), Config::asString);
            }
            return ConfigValues.create((Config)this, Optional::empty, Config::asString);
        }

        @Override
        public <T> ConfigValue<T> as(GenericType<T> genericType) {
            if (genericType.isClass()) {
                return this.as(genericType.rawType());
            }
            return ConfigValues.create((Config)this, genericType, this.mapper());
        }

        @Override
        public <T> ConfigValue<T> as(Class<T> type) {
            return ConfigValues.create((Config)this, type, this.mapper());
        }

        @Override
        public <T> ConfigValue<T> as(Function<Config, T> mapper) {
            return ConfigValues.create(this, mapper);
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
            return ConfigValues.createList(this, cfg -> cfg.as(type), cfg -> cfg.asList(type));
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
            return ConfigValues.createList(this, cfg -> cfg.as(mapper), cfg -> cfg.asList(mapper));
        }

        @Override
        public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
            io.helidon.common.config.ConfigValue nodeList = this.delegate.asNodeList();
            if (nodeList.isEmpty()) {
                return ConfigValues.create((Config)this, Optional::empty, Config::asNodeList);
            }
            return ConfigValues.create((Config)this, () -> Optional.of(nodeList.stream().flatMap(Collection::stream).map(ConfigProvider::wrapCommon).toList()), Config::asNodeList);
        }

        @Override
        public ConfigValue<Map<String, String>> asMap() throws MissingValueException {
            return ConfigValues.createMap(this, this.mapper());
        }

        public io.helidon.common.config.Config get(Config.Key key) {
            return this.delegate.get(key);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    static class CommonKeyWrapper
    implements Config.Key {
        private final Config.Key delegate;

        CommonKeyWrapper(Config.Key key) {
            this.delegate = key;
        }

        @Override
        public Config.Key parent() {
            return new CommonKeyWrapper(this.delegate.parent());
        }

        @Override
        public Config.Key child(Config.Key key) {
            return new CommonKeyWrapper(this.delegate.child(key));
        }

        @Override
        public boolean isRoot() {
            return this.delegate.isRoot();
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public int compareTo(Config.Key o) {
            return this.delegate.compareTo((Object)o);
        }
    }
}

