/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHelper;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AdjustmentUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class RecordFinalizerBase {
    protected static final AccountID ZERO_ACCOUNT_ID = AccountID.newBuilder().accountNum(0L).build();

    protected abstract boolean systemEntitiesCreated();

    @NonNull
    protected Map<AccountID, Long> hbarChangesFrom(@NonNull WritableAccountStore writableAccountStore, long maxLegalBalance) {
        HashMap<AccountID, Long> hbarChanges = new HashMap<AccountID, Long>();
        long netHbarBalance = 0L;
        for (AccountID modifiedAcctId : writableAccountStore.modifiedAccountsInState()) {
            Account modifiedAcct = Objects.requireNonNull(writableAccountStore.getAccountById(modifiedAcctId));
            Account persistedAcct = writableAccountStore.getOriginalValue(modifiedAcctId);
            long persistedBalance = persistedAcct != null ? persistedAcct.tinybarBalance() : 0L;
            HandleException.validateTrue((modifiedAcct.tinybarBalance() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
            HandleException.validateTrue((modifiedAcct.tinybarBalance() <= maxLegalBalance ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
            long netHbarChange = modifiedAcct.tinybarBalance() - persistedBalance;
            if (netHbarChange == 0L) continue;
            netHbarBalance = AdjustmentUtils.addExactOrThrowReason(netHbarBalance, netHbarChange, ResponseCodeEnum.FAIL_INVALID);
            hbarChanges.put(modifiedAcctId, netHbarChange);
        }
        if (netHbarBalance != 0L && this.systemEntitiesCreated()) {
            throw new HandleException(ResponseCodeEnum.FAIL_INVALID);
        }
        return hbarChanges;
    }

    @NonNull
    protected Map<EntityIDPair, Long> tokenRelChangesFrom(@NonNull WritableTokenRelationStore writableTokenRelStore, @NonNull IsCryptoTransfer isCryptoTransfer) {
        HashMap<EntityIDPair, Long> tokenRelChanges = new HashMap<EntityIDPair, Long>();
        for (EntityIDPair modifiedRel : writableTokenRelStore.modifiedTokens()) {
            boolean prevPointerChanged;
            AccountID relAcctId = modifiedRel.accountIdOrThrow();
            TokenID relTokenId = modifiedRel.tokenIdOrThrow();
            TokenRelation modifiedTokenRel = writableTokenRelStore.get(relAcctId, relTokenId);
            TokenRelation persistedTokenRel = writableTokenRelStore.getOriginalValue(relAcctId, relTokenId);
            long persistedBalance = persistedTokenRel != null ? persistedTokenRel.balance() : 0L;
            long modifiedTokenRelBalance = modifiedTokenRel != null ? modifiedTokenRel.balance() : 0L;
            HandleException.validateTrue((modifiedTokenRelBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
            long netFungibleChange = modifiedTokenRelBalance - persistedBalance;
            if (netFungibleChange != 0L) {
                tokenRelChanges.put(modifiedRel, netFungibleChange);
                continue;
            }
            boolean bl = prevPointerChanged = !Objects.equals(persistedTokenRel != null ? persistedTokenRel.previousToken() : null, modifiedTokenRel != null ? modifiedTokenRel.previousToken() : null);
            if (isCryptoTransfer != IsCryptoTransfer.YES || prevPointerChanged) continue;
            tokenRelChanges.put(modifiedRel, 0L);
        }
        return tokenRelChanges;
    }

    @NonNull
    protected List<TokenTransferList> asTokenTransferListFrom(@NonNull Map<EntityIDPair, Long> fungibleChanges, @NonNull IsCryptoTransfer isCryptoTransfer) {
        ArrayList<TokenTransferList> fungibleTokenTransferLists = new ArrayList<TokenTransferList>();
        HashMap acctAmountsByTokenId = new HashMap();
        for (Map.Entry<EntityIDPair, Long> entry : fungibleChanges.entrySet()) {
            TokenID tokenIdOfAcctAmountChange = entry.getKey().tokenId();
            AccountID accountIdOfAcctAmountChange = entry.getKey().accountId();
            if (!acctAmountsByTokenId.containsKey(tokenIdOfAcctAmountChange)) {
                acctAmountsByTokenId.put(tokenIdOfAcctAmountChange, new HashMap());
            }
            if (entry.getValue() == 0L && isCryptoTransfer != IsCryptoTransfer.YES) continue;
            HashMap tokenIdMap = (HashMap)acctAmountsByTokenId.get(tokenIdOfAcctAmountChange);
            tokenIdMap.merge(accountIdOfAcctAmountChange, entry.getValue(), Long::sum);
        }
        for (Map.Entry<Object, Long> entry : acctAmountsByTokenId.entrySet()) {
            HashMap singleTokenTransfers = (HashMap)((Object)entry.getValue());
            if (singleTokenTransfers.isEmpty()) continue;
            List<AccountAmount> aaList = StakingRewardsHelper.asAccountAmounts(singleTokenTransfers);
            aaList.sort(TokenComparators.ACCOUNT_AMOUNT_COMPARATOR);
            if (isCryptoTransfer == IsCryptoTransfer.YES) {
                long netAdjustment = 0L;
                for (AccountAmount aa : aaList) {
                    netAdjustment = AdjustmentUtils.addExactOrThrowReason(netAdjustment, aa.amount(), ResponseCodeEnum.FAIL_INVALID);
                }
                if (netAdjustment != 0L) {
                    throw new HandleException(ResponseCodeEnum.FAIL_INVALID);
                }
            }
            fungibleTokenTransferLists.add(TokenTransferList.newBuilder().token((TokenID)entry.getKey()).transfers(aaList).build());
        }
        return fungibleTokenTransferLists;
    }

    @NonNull
    protected Map<TokenID, List<NftTransfer>> nftChangesFrom(@NonNull WritableNftStore writableNftStore, @NonNull WritableTokenStore writableTokenStore, Map<EntityIDPair, Long> tokenRelChanges) {
        HashMap<TokenID, List<NftTransfer>> nftChanges = new HashMap<TokenID, List<NftTransfer>>();
        for (NftID nftId : writableNftStore.modifiedNfts()) {
            AccountID receiverAccountId;
            AccountID senderAccountId;
            Nft modifiedNft = writableNftStore.get(nftId);
            Nft persistedNft = writableNftStore.getOriginalValue(nftId);
            if (persistedNft != null) {
                if (persistedNft.hasOwnerId()) {
                    senderAccountId = persistedNft.ownerIdOrThrow();
                } else {
                    TokenID tokenId = nftId.tokenId();
                    Objects.requireNonNull(tokenId);
                    Token token = writableTokenStore.get(tokenId);
                    Objects.requireNonNull(token);
                    senderAccountId = token.treasuryAccountIdOrThrow();
                }
            } else {
                senderAccountId = ZERO_ACCOUNT_ID;
            }
            if (modifiedNft != null) {
                if (modifiedNft.hasOwnerId()) {
                    receiverAccountId = modifiedNft.ownerIdOrThrow();
                } else {
                    TokenID tokenId = nftId.tokenId();
                    Objects.requireNonNull(tokenId);
                    Token token = writableTokenStore.get(tokenId);
                    Objects.requireNonNull(token);
                    receiverAccountId = token.treasuryAccountIdOrThrow();
                }
            } else {
                receiverAccountId = ZERO_ACCOUNT_ID;
            }
            if (receiverAccountId.equals((Object)senderAccountId)) continue;
            RecordFinalizerBase.updateNftChanges(nftId, senderAccountId, receiverAccountId, nftChanges, tokenRelChanges);
        }
        for (TokenID tokenId : writableTokenStore.modifiedTokens()) {
            Token modifiedToken;
            Token originalToken = writableTokenStore.getOriginalValue(tokenId);
            if (!RecordFinalizerBase.bothExistButTreasuryChanged(originalToken, modifiedToken = Objects.requireNonNull(writableTokenStore.get(tokenId))) || originalToken.tokenType() != TokenType.NON_FUNGIBLE_UNIQUE) continue;
            RecordFinalizerBase.updateNftChanges(NftID.newBuilder().tokenId(tokenId).serialNumber(-1L).build(), originalToken.treasuryAccountId(), modifiedToken.treasuryAccountId(), nftChanges, tokenRelChanges);
        }
        return nftChanges;
    }

    private static boolean bothExistButTreasuryChanged(@Nullable Token originalToken, @NonNull Token modifiedToken) {
        return originalToken != null && !originalToken.treasuryAccountId().equals((Object)modifiedToken.treasuryAccountIdOrElse(AccountID.DEFAULT));
    }

    private static void updateNftChanges(NftID nftId, AccountID senderAccountId, AccountID receiverAccountId, Map<TokenID, List<NftTransfer>> nftChanges, @Nullable Map<EntityIDPair, Long> tokenRelChanges) {
        boolean isMint = senderAccountId.accountNum() == 0L;
        boolean isWipeOrBurn = receiverAccountId.accountNum() == 0L;
        boolean isTreasuryChange = nftId.serialNumber() == -1L;
        NftTransfer nftTransfer = NftTransfer.newBuilder().serialNumber(nftId.serialNumber()).senderAccountID(senderAccountId).receiverAccountID(receiverAccountId).build();
        if (!nftChanges.containsKey(nftId.tokenId())) {
            nftChanges.put(nftId.tokenId(), new ArrayList());
        }
        List<NftTransfer> currentNftChanges = nftChanges.get(nftId.tokenId());
        currentNftChanges.add(nftTransfer);
        nftChanges.put(nftId.tokenId(), currentNftChanges);
        if (!tokenRelChanges.isEmpty()) {
            EntityIDPair receiverEntityIdPair = EntityIDPair.newBuilder().accountId(receiverAccountId).tokenId(nftId.tokenId()).build();
            EntityIDPair senderEntityIdPair = EntityIDPair.newBuilder().accountId(senderAccountId).tokenId(nftId.tokenId()).build();
            if (isMint || isWipeOrBurn || isTreasuryChange) {
                tokenRelChanges.remove(receiverEntityIdPair);
                tokenRelChanges.remove(senderEntityIdPair);
            } else {
                if (tokenRelChanges.merge(receiverEntityIdPair, -1L, Long::sum) == 0L) {
                    tokenRelChanges.remove(receiverEntityIdPair);
                }
                if (tokenRelChanges.merge(senderEntityIdPair, 1L, Long::sum) == 0L) {
                    tokenRelChanges.remove(senderEntityIdPair);
                }
            }
        }
    }

    protected List<TokenTransferList> asTokenTransferListFromNftChanges(Map<TokenID, List<NftTransfer>> nftChanges) {
        ArrayList<TokenTransferList> nftTokenTransferLists = new ArrayList<TokenTransferList>();
        for (Map.Entry<TokenID, List<NftTransfer>> nftsForTokenId : nftChanges.entrySet()) {
            if (nftsForTokenId.getValue().isEmpty()) continue;
            List<NftTransfer> nftTransfersForTokenId = nftsForTokenId.getValue();
            nftTransfersForTokenId.sort(TokenComparators.NFT_TRANSFER_COMPARATOR);
            nftTokenTransferLists.add(TokenTransferList.newBuilder().token(nftsForTokenId.getKey()).nftTransfers(nftTransfersForTokenId).build());
        }
        return nftTokenTransferLists;
    }

    public static enum IsCryptoTransfer {
        YES,
        NO;

    }
}

