/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Consensus;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiConstants;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.hashgraph.HashgraphPictureOptions;
import com.swirlds.platform.gui.hashgraph.internal.EventSelector;
import com.swirlds.platform.gui.hashgraph.internal.GenerationCoordinates;
import com.swirlds.platform.gui.hashgraph.internal.HashgraphGuiUtils;
import com.swirlds.platform.gui.hashgraph.internal.PictureMetadata;
import com.swirlds.platform.gui.hashgraph.internal.RosterMetadata;
import com.swirlds.platform.internal.EventImpl;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.event.ItemEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class HashgraphPicture
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(HashgraphPicture.class);
    private final HashgraphGuiSource hashgraphSource;
    private final HashgraphPictureOptions options;
    private final EventSelector selector;
    private PictureMetadata pictureMetadata;
    private BufferedImage image = null;
    private RosterMetadata nonExpandedMetadata;
    private RosterMetadata expandedMetadata;
    private final Map<Long, Map<Long, GenerationCoordinates>> nodeIdToBranchIndexToCoordinates = new HashMap<Long, Map<Long, GenerationCoordinates>>();

    public HashgraphPicture(HashgraphGuiSource hashgraphSource, HashgraphPictureOptions options) {
        this.hashgraphSource = hashgraphSource;
        this.options = options;
        this.selector = new EventSelector();
        this.addMouseListener(this.selector);
        this.createMetadata();
    }

    private void createMetadata() {
        if ((this.expandedMetadata == null || this.nonExpandedMetadata == null) && this.hashgraphSource.isReady()) {
            this.expandedMetadata = new RosterMetadata(this.hashgraphSource.getRoster(), true);
            this.nonExpandedMetadata = new RosterMetadata(this.hashgraphSource.getRoster(), false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            EventImpl selectedEvent;
            List<EventImpl> events;
            RosterMetadata currentMetadata;
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, null);
                return;
            }
            if (!this.hashgraphSource.isReady()) {
                return;
            }
            this.createMetadata();
            g.setFont(HashgraphGuiConstants.HASHGRAPH_PICTURE_FONT);
            FontMetrics fm = g.getFontMetrics();
            Roster roster = this.hashgraphSource.getRoster();
            int numMem = roster.rosterEntries().size();
            RosterMetadata rosterMetadata = currentMetadata = this.options.isExpanded() ? this.expandedMetadata : this.nonExpandedMetadata;
            if (this.options.displayLatestEvents()) {
                long startGen = Math.max(this.hashgraphSource.getMaxGeneration() - (long)this.options.getNumGenerationsDisplay() + 1L, 0L);
                this.options.setStartGeneration(startGen);
                events = this.hashgraphSource.getEvents(startGen, this.options.getNumGenerationsDisplay());
            } else {
                events = this.hashgraphSource.getEvents(this.options.getStartGeneration(), this.options.getNumGenerationsDisplay());
            }
            if (events == null) {
                return;
            }
            events = events.stream().filter(e -> RosterUtils.getIndex((Roster)roster, (long)e.getCreatorId().id()) != -1).filter(e -> RosterUtils.getIndex((Roster)roster, (long)e.getCreatorId().id()) < numMem).toList();
            this.pictureMetadata = new PictureMetadata(fm, this.getSize(), currentMetadata, events, this.hashgraphSource, this.nodeIdToBranchIndexToCoordinates);
            this.selector.setMetadata(this.pictureMetadata);
            this.selector.setEventsInPicture(events);
            g.setColor(Color.BLACK);
            for (int i = 0; i < currentMetadata.getNumColumns(); ++i) {
                String name = currentMetadata.getLabel(i);
                int betweenGap = this.pictureMetadata.getGapBetweenColumns();
                int sideGap = this.pictureMetadata.getSideGap();
                int x = sideGap + i * betweenGap;
                g.drawLine(x, this.pictureMetadata.getYmin(), x, this.pictureMetadata.getYmax());
                Rectangle2D rect = fm.getStringBounds(name, g);
                g.drawString(name, (int)((double)x - rect.getWidth() / 2.0), (int)((double)this.pictureMetadata.getYmax() + rect.getHeight()));
            }
            int d = this.pictureMetadata.getD();
            if (this.nodeIdToBranchIndexToCoordinates.isEmpty()) {
                Set nodeIdSet = roster.rosterEntries().stream().map(RosterEntry::nodeId).map(NodeId::of).collect(Collectors.toSet());
                Iterator betweenGap = nodeIdSet.iterator();
                while (betweenGap.hasNext()) {
                    NodeId nodeId = (NodeId)betweenGap.next();
                    this.nodeIdToBranchIndexToCoordinates.put(nodeId.id(), new HashMap());
                }
            }
            for (EventImpl event : events) {
                this.drawLinksToParents(g, event);
            }
            for (EventImpl event : events) {
                this.drawEventCircle(g, event, this.options, d);
            }
            List<EventImpl> selectedEvents = events.stream().filter(this.selector::isSelected).toList();
            if (!selectedEvents.isEmpty() && (selectedEvent = selectedEvents.getFirst()) != null) {
                this.drawLinksToParents(g, selectedEvent);
                this.drawEventCircle(g, selectedEvent, this.options, d);
            }
        }
        catch (Exception e2) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error while painting", (Throwable)e2);
        }
    }

    private void drawBorderAroundEvent(Graphics g, int d, EventImpl event, Color borderColor) {
        int xPos = this.pictureMetadata.xpos(event.getOtherParent() != null ? (EventImpl)event.getOtherParent() : event, event) - d / 2;
        int yPos = this.pictureMetadata.ypos(event) - d / 2;
        g.setColor(borderColor);
        g.fillOval(xPos - 5, yPos - 5, d + 10, d + 10);
    }

    private void drawLinksToParents(Graphics g, EventImpl event) {
        Color currentColor;
        int d = this.pictureMetadata.getD();
        Graphics2D g2d = (Graphics2D)g;
        Stroke savedStroke = null;
        g.setColor(HashgraphGuiUtils.eventColor(event, this.options));
        boolean selectedLines = this.selector.isSelected(event);
        if (selectedLines) {
            g.setColor(Color.MAGENTA);
            savedStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(3.0f));
        }
        EventImpl e1 = (EventImpl)event.getSelfParent();
        EventImpl e2 = (EventImpl)event.getOtherParent();
        Roster roster = this.hashgraphSource.getRoster();
        if (e2 != null && (RosterUtils.getIndex((Roster)roster, (long)e2.getCreatorId().id()) == -1 || RosterUtils.getIndex((Roster)roster, (long)e2.getCreatorId().id()) >= roster.rosterEntries().size())) {
            e2 = null;
        }
        if (e1 != null && e1.getNGen() >= this.pictureMetadata.getMinGen()) {
            g.drawLine(this.pictureMetadata.xpos(e2, event), this.pictureMetadata.ypos(event), this.pictureMetadata.xpos(e2, e1), this.pictureMetadata.ypos(e1));
            if (selectedLines) {
                currentColor = g.getColor();
                this.drawBorderAroundEvent(g, d, e1, Color.MAGENTA);
                this.drawEventCircle(g, e1, this.options, d);
                g.setColor(currentColor);
            }
        }
        if (e2 != null && e2.getNGen() >= this.pictureMetadata.getMinGen()) {
            g.drawLine(this.pictureMetadata.xpos(e2, event), this.pictureMetadata.ypos(event), this.pictureMetadata.xpos(event, e2), this.pictureMetadata.ypos(e2));
            if (selectedLines) {
                currentColor = g.getColor();
                this.drawBorderAroundEvent(g, d, e2, Color.MAGENTA);
                this.drawEventCircle(g, e2, this.options, d);
                g.setColor(currentColor);
            }
        }
        if (selectedLines) {
            g2d.setStroke(savedStroke);
        }
    }

    private void drawEventCircle(Graphics g, EventImpl event, HashgraphPictureOptions options, int d) {
        Instant t;
        EventImpl e2;
        Consensus consensus = this.hashgraphSource.getEventStorage().getConsensus();
        FontMetrics fm = g.getFontMetrics();
        int fa = fm.getMaxAscent();
        int fd = fm.getMaxDescent();
        EventImpl eventImpl = e2 = event.getOtherParent() != null && RosterUtils.getIndex((Roster)this.hashgraphSource.getRoster(), (long)((EventImpl)event.getOtherParent()).getCreatorId().id()) != -1 ? (EventImpl)event.getOtherParent() : null;
        Color color = this.selector.isSelected(event) ? Color.MAGENTA : (this.selector.isStronglySeen(event) ? Color.CYAN : HashgraphGuiUtils.eventColor(event, options));
        int xPos = this.pictureMetadata.xpos(e2, event) - d / 2;
        int yPos = this.pictureMetadata.ypos(event) - d / 2;
        if (this.selector.isSelected(event)) {
            this.drawBorderAroundEvent(g, d, event, Color.GREEN);
        }
        g.setColor(color);
        g.fillOval(xPos, yPos, d, d);
        g.setFont(g.getFont().deriveFont(1));
        Object s = "";
        if (options.writeRoundCreated()) {
            s = (String)s + " " + event.getRoundCreated();
        }
        if (options.writeVote() && event.isWitness()) {
            for (int i = 0; i < event.getVotesSize(); ++i) {
                String vote = event.getVote(i) ? "T" : "F";
                s = (String)s + vote;
            }
        }
        if (options.writeEventHash()) {
            s = (String)s + " h:" + event.getBaseHash().toString().substring(0, 2);
        }
        if (options.writeRoundReceived() && event.getRoundReceived() > 0L) {
            s = (String)s + " " + event.getRoundReceived();
        }
        if (options.writeConsensusOrder() && event.isConsensus()) {
            s = (String)s + " " + event.getBaseEvent().getConsensusOrder();
        }
        if (options.writeConsensusTimeStamp() && (t = event.getConsensusTimestamp()) != null) {
            s = (String)s + " " + HashgraphGuiConstants.FORMATTER.format(t);
        }
        if (options.writeNGen()) {
            s = (String)s + " " + event.getNGen();
        }
        if (options.writeBirthRound()) {
            s = (String)s + " " + event.getBirthRound();
        }
        GossipEvent gossipEvent = event.getBaseEvent().getGossipEvent();
        if (options.writeBranches() && this.hashgraphSource.getEventStorage().getBranchedEventsMetadata().containsKey(gossipEvent)) {
            s = (String)s + " \\/ " + this.hashgraphSource.getEventStorage().getBranchedEventsMetadata().get(gossipEvent).branchIndex();
        }
        if (options.writeDeGen()) {
            s = (String)s + " " + event.getDeGen();
        }
        if (!((String)s).isEmpty()) {
            Rectangle2D rect = fm.getStringBounds((String)s, g);
            int x = (int)((double)this.pictureMetadata.xpos(e2, event) - rect.getWidth() / 2.0 - (double)fa / 4.0);
            int y = (int)((double)this.pictureMetadata.ypos(event) + rect.getHeight() / 2.0 - (double)(fd / 2));
            g.setColor(HashgraphGuiConstants.LABEL_OUTLINE);
            g.drawString((String)s, x - 1, y - 1);
            g.drawString((String)s, x + 1, y - 1);
            g.drawString((String)s, x - 1, y + 1);
            g.drawString((String)s, x + 1, y + 1);
            g.setColor(color);
            g.drawString((String)s, x, y);
        }
    }

    public void freezeChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            try {
                this.image = new Robot().createScreenCapture(new Rectangle(this.getLocationOnScreen(), this.getVisibleRect().getSize()));
            }
            catch (AWTException aWTException) {}
        } else if (e.getStateChange() == 2) {
            this.image = null;
        }
    }
}

