/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.http2.Http2Continuation;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2GoAway;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Ping;
import io.helidon.http.http2.Http2Priority;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2WindowUpdate;
import java.util.List;

final class Http2FrameListenerUtil {
    private Http2FrameListenerUtil() {
    }

    static Http2FrameListener toSingleListener(List<Http2FrameListener> sendFrameListeners) {
        if (sendFrameListeners.isEmpty()) {
            return NoOpFrameListener.INSTANCE;
        }
        if (sendFrameListeners.size() == 1) {
            return sendFrameListeners.get(0);
        }
        return new ListFrameListener(sendFrameListeners);
    }

    private static final class NoOpFrameListener
    implements Http2FrameListener {
        private static final NoOpFrameListener INSTANCE = new NoOpFrameListener();

        private NoOpFrameListener() {
        }
    }

    private static final class ListFrameListener
    implements Http2FrameListener {
        private final List<Http2FrameListener> delegates;

        ListFrameListener(List<Http2FrameListener> delegates) {
            this.delegates = delegates;
        }

        @Override
        public void frameHeader(SocketContext ctx, int streamId, BufferData frameHeader) {
            this.delegates.forEach(it -> it.frameHeader(ctx, streamId, frameHeader));
        }

        @Override
        public void frameHeader(SocketContext ctx, int streamId, Http2FrameHeader header) {
            this.delegates.forEach(it -> it.frameHeader(ctx, streamId, header));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, BufferData data) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, data));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2Priority priority) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, priority));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2RstStream rstStream) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, rstStream));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2Settings settings) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, settings));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2Ping ping) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, ping));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2GoAway goAway) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, goAway));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2WindowUpdate windowUpdate) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, windowUpdate));
        }

        @Override
        public void headers(SocketContext ctx, int streamId, Http2Headers headers) {
            this.delegates.forEach(it -> it.headers(ctx, streamId, headers));
        }

        @Override
        public void frame(SocketContext ctx, int streamId, Http2Continuation continuation) {
            this.delegates.forEach(it -> it.frame(ctx, streamId, continuation));
        }
    }
}

