/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.buffers.DataReader;
import io.helidon.http.DirectHandler;
import io.helidon.http.Headers;
import io.helidon.http.Http1HeadersParser;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RequestException;
import io.helidon.http.WritableHeaders;
import io.helidon.webserver.http.DirectTransportRequest;

public final class Http1Headers {
    private final DataReader reader;
    private final int maxHeadersSize;
    private final boolean validateHeaders;

    public Http1Headers(DataReader reader, int maxHeadersSize, boolean validateHeaders) {
        this.reader = reader;
        this.maxHeadersSize = maxHeadersSize;
        this.validateHeaders = validateHeaders;
    }

    public WritableHeaders<?> readHeaders(HttpPrologue prologue) {
        try {
            return Http1HeadersParser.readHeaders((DataReader)this.reader, (int)this.maxHeadersSize, (boolean)this.validateHeaders);
        }
        catch (DataReader.IncorrectNewLineException | IllegalArgumentException | IllegalStateException e) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, (Headers)WritableHeaders.create())).message(e.getMessage()).cause(e).build();
        }
    }
}

