/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.AbstractHashable;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class EventMetadata
extends AbstractHashable {
    private final NodeId creatorId;
    private final EventDescriptorWrapper selfParent;
    private final List<EventDescriptorWrapper> otherParents;
    private final List<EventDescriptorWrapper> allParents;
    private final Instant timeCreated;
    private final List<TransactionWrapper> transactions;
    private EventDescriptorWrapper descriptor;
    private final long birthRound;

    public EventMetadata(@NonNull NodeId creatorId, @NonNull List<EventDescriptorWrapper> allParents, @NonNull Instant timeCreated, @NonNull List<Bytes> transactions, long birthRound) {
        Objects.requireNonNull(transactions, "The transactions must not be null");
        this.creatorId = Objects.requireNonNull(creatorId, "The creatorId must not be null");
        this.allParents = Objects.requireNonNull(allParents, "The allParents must not be null");
        if (!allParents.isEmpty() && allParents.getFirst().creator().equals(creatorId)) {
            this.selfParent = allParents.getFirst();
            this.otherParents = allParents.subList(1, allParents.size());
        } else {
            this.selfParent = null;
            this.otherParents = allParents;
        }
        this.timeCreated = Objects.requireNonNull(timeCreated, "The timeCreated must not be null");
        this.transactions = Objects.requireNonNull(transactions, "transactions must not be null").stream().map(TransactionWrapper::new).toList();
        this.birthRound = birthRound;
    }

    public EventMetadata(@NonNull GossipEvent gossipEvent) {
        this(NodeId.of(Objects.requireNonNull(gossipEvent.eventCore(), "The eventCore must not be null").creatorNodeId()), gossipEvent.parents().stream().map(EventDescriptorWrapper::new).toList(), HapiUtils.asInstant((Timestamp)Objects.requireNonNull(gossipEvent.eventCore().timeCreated(), "The timeCreated must not be null")), gossipEvent.transactions(), gossipEvent.eventCore().birthRound());
    }

    public long getBirthRound() {
        return this.birthRound;
    }

    @NonNull
    public NodeId getCreatorId() {
        return this.creatorId;
    }

    @Nullable
    public EventDescriptorWrapper getSelfParent() {
        return this.selfParent;
    }

    @NonNull
    public List<EventDescriptorWrapper> getOtherParents() {
        return this.otherParents;
    }

    public boolean hasOtherParents() {
        return this.otherParents != null && !this.otherParents.isEmpty();
    }

    @NonNull
    public List<EventDescriptorWrapper> getAllParents() {
        return this.allParents;
    }

    @NonNull
    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    @NonNull
    public List<TransactionWrapper> getTransactions() {
        return this.transactions;
    }

    @NonNull
    public EventDescriptorWrapper getDescriptor() {
        if (this.descriptor == null) {
            if (this.getHash() == null) {
                throw new IllegalStateException("The hash of the event must be set before creating the descriptor");
            }
            this.descriptor = new EventDescriptorWrapper(new EventDescriptor(this.getHash().getBytes(), this.creatorId.id(), this.getBirthRound()));
        }
        return this.descriptor;
    }
}

