/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.AnnotationProperty;
import java.util.Objects;
import java.util.Optional;

class AnnotationPropertyImpl
implements AnnotationProperty {
    private final Object value;
    private final AnnotationProperty.ConstantValue constantValue;

    AnnotationPropertyImpl(Object value) {
        this(value, null);
    }

    AnnotationPropertyImpl(Object value, AnnotationProperty.ConstantValue constantValue) {
        this.value = value;
        this.constantValue = constantValue;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Optional<AnnotationProperty.ConstantValue> constantValue() {
        return Optional.ofNullable(this.constantValue);
    }

    public String toString() {
        if (this.constantValue == null) {
            return String.valueOf(this.value);
        }
        return this.constantValue.type().fqName() + "." + this.constantValue.name();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AnnotationPropertyImpl) {
            AnnotationPropertyImpl api = (AnnotationPropertyImpl)obj;
            return Objects.equals(this.value, api.value);
        }
        return Objects.equals(obj, this.value);
    }
}

