/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.throttle;

import com.hedera.hapi.node.base.EvmHookCall;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleServiceManager;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.throttle.ThrottleException;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DispatchUsageManager {
    public static final Set<HederaFunctionality> CONTRACT_OPERATIONS = EnumSet.of(HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.CONTRACT_CALL, HederaFunctionality.ETHEREUM_TRANSACTION, HederaFunctionality.HOOK_DISPATCH);
    private final NetworkInfo networkInfo;
    private final OpWorkflowMetrics opWorkflowMetrics;
    private final ThrottleServiceManager throttleServiceManager;
    private final NetworkUtilizationManager networkUtilizationManager;

    @Inject
    public DispatchUsageManager(@NonNull NetworkInfo networkInfo, @NonNull OpWorkflowMetrics opWorkflowMetrics, @NonNull ThrottleServiceManager throttleServiceManager, @NonNull NetworkUtilizationManager networkUtilizationManager) {
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.opWorkflowMetrics = Objects.requireNonNull(opWorkflowMetrics);
        this.throttleServiceManager = Objects.requireNonNull(throttleServiceManager);
        this.networkUtilizationManager = Objects.requireNonNull(networkUtilizationManager);
    }

    public void screenForCapacity(@NonNull Dispatch dispatch) throws ThrottleException {
        if (dispatch.throttleStrategy() == HandleContext.ConsensusThrottling.ON) {
            ReadableStates readableStates = dispatch.stack().getReadableStates("CongestionThrottleService");
            this.throttleServiceManager.resetThrottlesUnconditionally(readableStates);
            boolean isThrottled = this.networkUtilizationManager.trackTxn(dispatch.txnInfo(), dispatch.consensusNow(), dispatch.stack());
            if (this.networkUtilizationManager.wasLastTxnGasThrottled()) {
                throw ThrottleException.newGasThrottleException();
            }
            if (isThrottled) {
                throw ThrottleException.newNativeThrottleException();
            }
        }
    }

    public void finalizeAndSaveUsage(@NonNull Dispatch dispatch) {
        HederaFunctionality function = dispatch.txnInfo().functionality();
        if (CONTRACT_OPERATIONS.contains(function)) {
            this.leakUnusedGas(dispatch);
        }
        if ((dispatch.txnCategory() == HandleContext.TransactionCategory.USER || dispatch.txnCategory() == HandleContext.TransactionCategory.NODE) && dispatch.streamBuilder().status() != ResponseCodeEnum.SUCCESS) {
            if (ThrottleAccumulator.canAutoCreate(function)) {
                this.reclaimFailedCryptoCreateCapacity(dispatch);
            }
            if (ThrottleAccumulator.canAutoAssociate(function)) {
                this.reclaimFailedTokenAssociate(dispatch);
            }
        }
        this.throttleServiceManager.saveThrottleSnapshotsAndCongestionLevelStartsTo(dispatch.stack());
    }

    public void trackFeePayments(@NonNull Dispatch dispatch) {
        this.networkUtilizationManager.trackFeePayments(dispatch.consensusNow(), dispatch.stack());
    }

    private void leakUnusedGas(@NonNull Dispatch dispatch) {
        StreamBuilder builder = dispatch.streamBuilder();
        if (builder.hasContractResult()) {
            long gasUsed = builder.getGasUsedForContractTxn();
            this.opWorkflowMetrics.addGasUsed(gasUsed);
            ContractsConfig contractsConfig = (ContractsConfig)dispatch.config().getConfigData(ContractsConfig.class);
            if (contractsConfig.throttleThrottleByGas()) {
                TransactionInfo txnInfo = dispatch.txnInfo();
                long gasLimitForContractTx = DispatchUsageManager.getGasLimitForContractTx(txnInfo.txBody(), txnInfo.functionality());
                long excessAmount = gasLimitForContractTx - gasUsed;
                this.networkUtilizationManager.leakUnusedGasPreviouslyReserved(txnInfo, excessAmount);
            }
        }
    }

    private void reclaimFailedCryptoCreateCapacity(@NonNull Dispatch dispatch) {
        ReadableAccountStore readableAccountStore = dispatch.readableStoreFactory().getStore(ReadableAccountStore.class);
        int numImplicitCreations = this.throttleServiceManager.numImplicitCreations(dispatch.txnInfo().txBody(), readableAccountStore);
        if (this.usedSelfFrontendThrottleCapacity(numImplicitCreations, dispatch.txnInfo().txBody())) {
            this.throttleServiceManager.reclaimFrontendThrottleCapacity(numImplicitCreations, HederaFunctionality.CRYPTO_CREATE);
        }
    }

    private void reclaimFailedTokenAssociate(@NonNull Dispatch dispatch) {
        ReadableTokenRelationStore readableTokenRelStore = dispatch.readableStoreFactory().getStore(ReadableTokenRelationStore.class);
        int numAutoAssociations = this.throttleServiceManager.numAutoAssociations(dispatch.txnInfo().txBody(), readableTokenRelStore);
        if (this.usedSelfFrontendThrottleCapacity(numAutoAssociations, dispatch.txnInfo().txBody())) {
            this.throttleServiceManager.reclaimFrontendThrottleCapacity(numAutoAssociations, HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT);
        }
    }

    private boolean usedSelfFrontendThrottleCapacity(int numUsedCapacity, @NonNull TransactionBody txnBody) {
        return numUsedCapacity > 0 && txnBody.nodeAccountIDOrThrow().equals((Object)this.networkInfo.selfNodeInfo().accountId());
    }

    private static long getGasLimitForContractTx(@NonNull TransactionBody txnBody, @NonNull HederaFunctionality function) {
        if (function == HederaFunctionality.CONTRACT_CREATE) {
            return txnBody.contractCreateInstanceOrElse(ContractCreateTransactionBody.DEFAULT).gas();
        }
        if (function == HederaFunctionality.ETHEREUM_TRANSACTION) {
            EthereumTransactionBody rawEthTxn = txnBody.ethereumTransactionOrElse(EthereumTransactionBody.DEFAULT);
            EthTxData ethTxData = EthTxData.populateEthTxData((byte[])rawEthTxn.ethereumData().toByteArray());
            return ethTxData != null ? ethTxData.gasLimit() : 0L;
        }
        if (function == HederaFunctionality.HOOK_DISPATCH) {
            return txnBody.hookDispatchOrThrow().executionOrElse(HookExecution.DEFAULT).callOrElse(HookCall.DEFAULT).evmHookCallOrElse(EvmHookCall.DEFAULT).gasLimit();
        }
        return txnBody.contractCallOrElse(ContractCallTransactionBody.DEFAULT).gas();
    }
}

