/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import io.helidon.metadata.hson.Hson;
import io.helidon.metadata.hson.HsonException;
import io.helidon.metadata.hson.HsonValues;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;

final class HsonStruct
implements Hson.Struct {
    private final Map<String, Hson.Value<?>> values;

    private HsonStruct(Map<String, Hson.Value<?>> values) {
        this.values = values;
    }

    @Override
    public Hson.Struct value() {
        return this;
    }

    @Override
    public Optional<Hson.Value<?>> value(String key) {
        return Optional.ofNullable(this.values.get(key));
    }

    @Override
    public Optional<Boolean> booleanValue(String key) {
        return this.getValue(key, Hson.Type.BOOLEAN);
    }

    @Override
    public boolean booleanValue(String key, boolean defaultValue) {
        return this.booleanValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<Hson.Struct> structValue(String key) {
        return this.getValue(key, Hson.Type.STRUCT);
    }

    @Override
    public Optional<String> stringValue(String key) {
        return this.getValue(key, Hson.Type.STRING);
    }

    @Override
    public String stringValue(String key, String defaultValue) {
        return this.stringValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<Integer> intValue(String key) {
        return this.getValue(key, Hson.Type.NUMBER).map(BigDecimal::intValue);
    }

    @Override
    public int intValue(String key, int defaultValue) {
        return this.intValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<Double> doubleValue(String key) {
        return this.getValue(key, Hson.Type.NUMBER).map(BigDecimal::doubleValue);
    }

    @Override
    public double doubleValue(String key, double defaultValue) {
        return this.doubleValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<BigDecimal> numberValue(String key) {
        return this.getValue(key, Hson.Type.NUMBER);
    }

    @Override
    public BigDecimal numberValue(String key, BigDecimal defaultValue) {
        return this.numberValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<List<String>> stringArray(String key) {
        return this.getTypedList(key, Hson.Array::getStrings);
    }

    @Override
    public Optional<List<Hson.Struct>> structArray(String key) {
        return this.getTypedList(key, Hson.Array::getStructs);
    }

    @Override
    public Optional<List<BigDecimal>> numberArray(String key) {
        return this.getTypedList(key, Hson.Array::getNumbers);
    }

    @Override
    public Optional<List<Boolean>> booleanArray(String key) {
        return this.getTypedList(key, Hson.Array::getBooleans);
    }

    @Override
    public Optional<Hson.Array> arrayValue(String key) {
        Hson.Value<?> jValue = this.values.get(key);
        if (jValue == null) {
            return Optional.empty();
        }
        if (jValue.type() != Hson.Type.ARRAY) {
            throw new HsonException(this.exceptionMessage(key, " array requested, yet this key is not an array, but " + String.valueOf((Object)this.type())));
        }
        return Optional.of((Hson.Array)jValue);
    }

    @Override
    public Set<String> keys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.values.keySet());
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public void write(PrintWriter writer) {
        Objects.requireNonNull(writer);
        writer.write(123);
        AtomicBoolean first = new AtomicBoolean(true);
        this.values.forEach((key, value) -> {
            this.writeNext(writer, first);
            writer.write(34);
            writer.write((String)key);
            writer.write(34);
            writer.write(58);
            value.write(writer);
        });
        writer.write(125);
    }

    @Override
    public Hson.Type type() {
        return Hson.Type.STRUCT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HsonStruct)) {
            return false;
        }
        HsonStruct struct = (HsonStruct)o;
        return Objects.equals(this.values, struct.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.values);
    }

    public String toString() {
        return "{" + String.valueOf(this.values) + "}";
    }

    private <T> Optional<T> getValue(String key, Hson.Type type) {
        Hson.Value<?> jValue = this.values.get(key);
        if (jValue == null || jValue.type() == Hson.Type.NULL) {
            return Optional.empty();
        }
        if (jValue.type() != type) {
            throw new HsonException(this.exceptionMessage(key, "requested as a " + String.valueOf((Object)type) + ", but it is of type " + String.valueOf((Object)jValue.type())));
        }
        return Optional.of(jValue.value());
    }

    private <T> Optional<List<T>> getTypedList(String key, Function<Hson.Array, List<T>> arrayFunction) {
        try {
            return this.arrayValue(key).map(arrayFunction);
        }
        catch (HsonException e) {
            throw new HsonException(this.exceptionMessage(key, " failed to get typed array"), e);
        }
    }

    private String exceptionMessage(String key, String message) {
        return "Struct key \"" + key + "\": " + message;
    }

    private void writeNext(PrintWriter metaWriter, AtomicBoolean first) {
        if (first.get()) {
            first.set(false);
            return;
        }
        metaWriter.write(44);
    }

    static class Builder
    implements Hson.Struct.Builder {
        private final Map<String, Hson.Value<?>> values = new LinkedHashMap();

        Builder() {
        }

        public Hson.Struct build() {
            return new HsonStruct(new LinkedHashMap(this.values));
        }

        @Override
        public Builder unset(String key) {
            Objects.requireNonNull(key, "key cannot be null");
            this.values.remove(key);
            return this;
        }

        @Override
        public Hson.Struct.Builder setNull(String key) {
            this.values.put(key, HsonValues.NullValue.INSTANCE);
            return this;
        }

        @Override
        public Builder set(String key, Hson.Value<?> value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public Builder set(String key, String value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, HsonValues.StringValue.create(value));
            return this;
        }

        @Override
        public Builder set(String key, boolean value) {
            Objects.requireNonNull(key, "key cannot be null");
            this.values.put(key, HsonValues.BooleanValue.create(value));
            return this;
        }

        @Override
        public Builder set(String key, float value) {
            Objects.requireNonNull(key, "key cannot be null");
            return this.set(key, new BigDecimal(String.valueOf(value)));
        }

        @Override
        public Builder set(String key, double value) {
            Objects.requireNonNull(key, "key cannot be null");
            return this.set(key, new BigDecimal(String.valueOf(value)));
        }

        @Override
        public Builder set(String key, int value) {
            Objects.requireNonNull(key, "key cannot be null");
            this.values.put(key, HsonValues.NumberValue.create(new BigDecimal(value)));
            return this;
        }

        @Override
        public Builder set(String key, long value) {
            Objects.requireNonNull(key, "key cannot be null");
            this.values.put(key, HsonValues.NumberValue.create(new BigDecimal(value)));
            return this;
        }

        @Override
        public Builder set(String key, BigDecimal value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, HsonValues.NumberValue.create(value));
            return this;
        }

        @Override
        public Builder set(String key, Hson.Array value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, value);
            return this;
        }

        @Override
        public Builder setStructs(String key, List<Hson.Struct> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.create(value));
            return this;
        }

        @Override
        public Builder setStrings(String key, List<String> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.createStrings(value));
            return this;
        }

        @Override
        public Builder setLongs(String key, List<Long> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.createNumbers(value.stream().map(BigDecimal::new).collect(Collectors.toUnmodifiableList())));
            return this;
        }

        @Override
        public Builder setDoubles(String key, List<Double> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.createNumbers(value.stream().map(BigDecimal::new).collect(Collectors.toUnmodifiableList())));
            return this;
        }

        @Override
        public Builder setNumbers(String key, List<BigDecimal> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.createNumbers(value));
            return this;
        }

        @Override
        public Builder setBooleans(String key, List<Boolean> value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.values.put(key, Hson.Array.createBooleans(value));
            return this;
        }
    }
}

