/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.hooks.LambdaMappingEntries;
import com.hedera.hapi.node.hooks.LambdaMappingEntry;
import com.hedera.hapi.node.hooks.LambdaSStoreTransactionBody;
import com.hedera.hapi.node.hooks.LambdaStorageSlot;
import com.hedera.hapi.node.hooks.LambdaStorageUpdate;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.hooks.EvmHookType;
import com.hedera.hapi.node.state.hooks.LambdaSlotKey;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LambdaSStoreHandler
implements TransactionHandler {
    private static final Logger log = LoggerFactory.getLogger(LambdaSStoreHandler.class);
    public static final long ZERO_INTO_ZERO_GAS_COST = 2100L;
    public static final long NONZERO_INTO_ZERO_GAS_COST = 22100L;
    public static final long ZERO_INTO_NONZERO_GAS_COST = 200L;
    public static final long NONZERO_INTO_NONZERO_GAS_COST = 5000L;
    public static final long NOOP_NONZERO_INTO_NONZERO_GAS_COST = 2100L;
    public static final long MAX_UPDATE_BYTES_LEN = 32L;

    @Inject
    public LambdaSStoreHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasHookId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookId hookId = op.hookIdOrThrow();
        PreCheckException.validateTruePreCheck((boolean)hookId.hasEntityId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookEntityId.EntityIdOneOfType ownerType = (HookEntityId.EntityIdOneOfType)hookId.entityIdOrThrow().entityId().kind();
        PreCheckException.validateTruePreCheck((ownerType != HookEntityId.EntityIdOneOfType.UNSET ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        PreCheckException.validateFalsePreCheck((boolean)op.storageUpdates().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.EMPTY_LAMBDA_STORAGE_UPDATE);
        for (LambdaStorageUpdate update : op.storageUpdates()) {
            if (update.hasStorageSlot()) {
                this.validateSlot(update.storageSlotOrThrow());
                continue;
            }
            if (update.hasMappingEntries()) {
                LambdaMappingEntries mappingEntries = update.mappingEntriesOrThrow();
                this.validateWord(mappingEntries.mappingSlot());
                for (LambdaMappingEntry entry : mappingEntries.entries()) {
                    this.validateEntry(entry);
                }
                continue;
            }
            throw new PreCheckException(ResponseCodeEnum.EMPTY_LAMBDA_STORAGE_UPDATE);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        ReadableEvmHookStore store = (ReadableEvmHookStore)context.createStore(ReadableEvmHookStore.class);
        HookId hookId = LambdaSStoreHandler.effectiveHookId(op.hookIdOrThrow());
        EvmHookState hook = store.getEvmHook(hookId);
        PreCheckException.validateTruePreCheck((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
        PreCheckException.validateTruePreCheck((hook.type() == EvmHookType.LAMBDA ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_IS_NOT_A_LAMBDA);
        AccountID ownerAccountId = hookId.entityIdOrThrow().accountIdOrThrow();
        if (hook.hasAdminKey()) {
            context.requireKeyOrThrow(ownerAccountId, ownerKey -> Key.newBuilder().thresholdKey(ThresholdKey.newBuilder().threshold(1).keys(new KeyList(List.of(ownerKey, hook.adminKeyOrThrow())))).build(), ResponseCodeEnum.INVALID_HOOK_ID);
        } else {
            context.requireKeyOrThrowOnDeleted(ownerAccountId, ResponseCodeEnum.INVALID_HOOK_ID);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        LambdaSStoreTransactionBody op = context.body().lambdaSstoreOrThrow();
        WritableEvmHookStore lambdaStore = (WritableEvmHookStore)context.storeFactory().writableStore(WritableEvmHookStore.class);
        List storageUpdates = op.storageUpdates();
        HooksConfig config = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleException.validateTrue((storageUpdates.size() <= config.maxLambdaSStoreUpdates() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOO_MANY_LAMBDA_STORAGE_UPDATES);
        HookId hookId = LambdaSStoreHandler.effectiveHookId(op.hookIdOrThrow());
        int delta = lambdaStore.updateStorage(hookId, op.storageUpdates());
        TokenServiceApi tokenServiceApi = (TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.updateLambdaStorageSlots(hookId.entityIdOrThrow().accountIdOrThrow(), delta, op.hookIdOrThrow().entityIdOrThrow().hasContractId());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        LambdaSStoreTransactionBody op = feeContext.body().lambdaSstoreOrThrow();
        long effectiveGas = 0L;
        try {
            HookId hookId = LambdaSStoreHandler.effectiveHookId(op.hookIdOrThrow());
            ReadableEvmHookStore store = (ReadableEvmHookStore)feeContext.readableStore(ReadableEvmHookStore.class);
            for (LambdaStorageUpdate update : op.storageUpdates()) {
                if (update.hasStorageSlot()) {
                    LambdaStorageSlot slot = update.storageSlotOrThrow();
                    SlotValue oldSlotValue = store.getSlotValue(new LambdaSlotKey(hookId, slot.key()));
                    Bytes oldValue = oldSlotValue == null ? null : oldSlotValue.value();
                    effectiveGas += this.effectiveGasCost(oldValue, slot.value());
                    continue;
                }
                if (!update.hasMappingEntries()) continue;
                LambdaMappingEntries entries = update.mappingEntriesOrThrow();
                Bytes p = HookUtils.leftPad32((Bytes)entries.mappingSlot());
                for (LambdaMappingEntry entry : entries.entries()) {
                    Bytes key = HookUtils.slotKeyOfMappingEntry((Bytes)p, (LambdaMappingEntry)entry);
                    SlotValue oldSlotValue = store.getSlotValue(new LambdaSlotKey(hookId, key));
                    Bytes oldValue = oldSlotValue == null ? null : oldSlotValue.value();
                    effectiveGas += this.effectiveGasCost(oldValue, entry.value());
                }
            }
        }
        catch (Exception unexpected) {
            log.warn("Unexpected exception calculating fees for LambdaSStore", (Throwable)unexpected);
            effectiveGas = (long)this.slotCount(op.storageUpdates()) * 5000L;
        }
        return calculator.addGas(effectiveGas).calculate();
    }

    private int slotCount(@NonNull List<LambdaStorageUpdate> storageUpdates) {
        int count = 0;
        for (LambdaStorageUpdate update : storageUpdates) {
            if (update.hasStorageSlot()) {
                ++count;
                continue;
            }
            if (!update.hasMappingEntries()) continue;
            count += update.mappingEntriesOrThrow().entries().size();
        }
        return count;
    }

    private long effectiveGasCost(@Nullable Bytes oldValue, @NonNull Bytes newValue) {
        if (oldValue == null) {
            return newValue.length() == 0L ? 2100L : 22100L;
        }
        if (newValue.length() == 0L) {
            return 200L;
        }
        return oldValue.equals((Object)newValue) ? 2100L : 5000L;
    }

    private void validateSlot(@NonNull LambdaStorageSlot slot) throws PreCheckException {
        this.validateWord(slot.key());
        this.validateWord(slot.value());
    }

    private void validateEntry(@NonNull LambdaMappingEntry entry) throws PreCheckException {
        this.validateWord(entry.value());
    }

    private void validateWord(@NonNull Bytes bytes) throws PreCheckException {
        PreCheckException.validateTruePreCheck((bytes.length() <= 32L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.LAMBDA_STORAGE_UPDATE_BYTES_TOO_LONG);
        Bytes minimalBytes = HookUtils.minimalRepresentationOf((Bytes)bytes);
        PreCheckException.validateTruePreCheck((bytes == minimalBytes ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.LAMBDA_STORAGE_UPDATE_BYTES_MUST_USE_MINIMAL_REPRESENTATION);
    }

    private static HookId effectiveHookId(@NonNull HookId hookId) {
        HookEntityId entityId = hookId.entityIdOrThrow();
        return entityId.hasContractId() ? HookId.newBuilder().entityId(HookEntityId.newBuilder().accountId(HookUtils.asAccountId((ContractID)entityId.contractIdOrThrow()))).hookId(hookId.hookId()).build() : hookId;
    }
}

