/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.Value;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

abstract class HeaderValueBase
implements Header {
    private static final String[] QUALIFIER = new String[]{"http", "header"};
    private final HeaderName name;
    private final String actualName;
    private final String firstValue;
    private final boolean changing;
    private final boolean sensitive;

    HeaderValueBase(HeaderName name, boolean changing, boolean sensitive, String value) {
        this.name = name;
        this.actualName = name.defaultCase();
        this.changing = changing;
        this.sensitive = sensitive;
        this.firstValue = value;
    }

    @Override
    public String name() {
        return this.actualName;
    }

    @Override
    public HeaderName headerName() {
        return this.name;
    }

    public String get() {
        return this.firstValue;
    }

    public String getString() {
        return this.get();
    }

    public <T> T get(Class<T> type) {
        return (T)MapperManager.global().map((Object)this.get(), String.class, type, QUALIFIER);
    }

    public <N> Value<N> as(Function<? super String, ? extends N> mapper) {
        return Value.create((Mappers)MapperManager.global(), (String)this.name(), mapper.apply(this.get()), (String[])QUALIFIER);
    }

    public <N> Value<N> as(Class<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public Value<String> asString() {
        return new UnmappedValue<String>(GenericType.STRING, this.name(), this.get());
    }

    public <N> Value<N> as(GenericType<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public Optional<String> asOptional() throws MapperException {
        return this.asString().asOptional();
    }

    public Value<Boolean> asBoolean() {
        return this.asString().asBoolean();
    }

    public Value<Integer> asInt() {
        return this.asString().asInt();
    }

    public Value<Long> asLong() {
        return this.asString().asLong();
    }

    public Value<Double> asDouble() {
        return this.asString().asDouble();
    }

    @Override
    public abstract int valueCount();

    @Override
    public boolean sensitive() {
        return this.sensitive;
    }

    @Override
    public boolean changing() {
        return this.changing;
    }

    public int hashCode() {
        return Objects.hash(this.changing, this.sensitive, this.actualName, this.allValues());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderValueBase)) {
            return false;
        }
        HeaderValueBase that = (HeaderValueBase)o;
        return this.changing == that.changing && this.sensitive == that.sensitive && this.actualName.equals(that.actualName) && this.valueCount() == that.valueCount() && this.allValues().equals(that.allValues());
    }

    public String toString() {
        return "HttpHeaderImpl[name=" + String.valueOf(this.name) + ", values=" + String.valueOf(this.allValues()) + ", changing=" + this.changing + ", sensitive=" + this.sensitive + "]";
    }

    private static final class UnmappedValue<T>
    implements Value<T> {
        private final String name;
        private final T value;
        private final GenericType<T> type;
        private final boolean isClass;
        private final Class<?> theClass;

        private UnmappedValue(GenericType<T> type, String name, T value) {
            this.type = type;
            this.name = name;
            this.value = value;
            this.isClass = type.isClass();
            this.theClass = type.rawType();
        }

        public String name() {
            return this.name;
        }

        public T get() {
            return this.value;
        }

        public <N> Value<N> as(Class<N> type) throws MapperException {
            if (this.isType(type)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).as(type);
        }

        public <N> Value<N> as(GenericType<N> type) throws MapperException {
            if (type.equals(this.type)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).as(type);
        }

        public <N> Value<N> as(Function<? super T, ? extends N> mapper) {
            N value = mapper.apply(this.value);
            return new UnmappedValue<N>(GenericType.create(value), this.name, value);
        }

        public Optional<T> asOptional() throws MapperException {
            return Optional.of(this.value);
        }

        public Value<Boolean> asBoolean() {
            if (this.isType(Boolean.class) || this.isType(Boolean.TYPE)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).asBoolean();
        }

        public Value<String> asString() {
            if (this.isType(String.class)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).asString();
        }

        public Value<Integer> asInt() {
            if (this.isType(Integer.class) || this.isType(Integer.TYPE)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).asInt();
        }

        public Value<Long> asLong() {
            if (this.isType(Long.class) || this.isType(Long.TYPE)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).asLong();
        }

        public Value<Double> asDouble() {
            if (this.isType(Double.class) || this.isType(Double.TYPE)) {
                return this;
            }
            return Value.create((Mappers)MapperManager.global(), (String)this.name, this.value, this.type, (String[])QUALIFIER).asDouble();
        }

        private boolean isType(Class<?> desired) {
            return this.isClass && desired == this.theClass;
        }
    }
}

