/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.service.registry.Scopes;
import io.helidon.service.registry.Service;
import io.helidon.webserver.RequestScopeFeature;
import io.helidon.webserver.spi.ServerFeatureProvider;
import java.util.function.Supplier;

@Weight(value=1000.0)
@Service.Singleton
public class RequestScopeFeatureProvider
implements ServerFeatureProvider<RequestScopeFeature> {
    private final Supplier<Scopes> scopes;

    RequestScopeFeatureProvider(Supplier<Scopes> scopes) {
        this.scopes = scopes;
    }

    public String configKey() {
        return "request-scope";
    }

    public RequestScopeFeature create(Config config, String name) {
        return RequestScopeFeature.create(this.scopes, (Boolean)config.get("enabled").asBoolean().orElse((Object)false));
    }
}

