/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.concurrency.limits.FixedLimit;
import io.helidon.common.concurrency.limits.FixedLimitConfigBlueprint;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.concurrency.limits.FixedLimitConfigBlueprint")
public interface FixedLimitConfig
extends FixedLimitConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FixedLimitConfig instance) {
        return (Builder)FixedLimitConfig.builder().from(instance);
    }

    public static FixedLimitConfig create(Config config) {
        return ((Builder)FixedLimitConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static FixedLimitConfig create(io.helidon.common.config.Config config) {
        return FixedLimitConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static FixedLimitConfig create() {
        return FixedLimitConfig.builder().buildPrototype();
    }

    @Override
    public int permits();

    @Override
    public boolean fair();

    @Override
    public int queueLength();

    @Override
    public Duration queueTimeout();

    @Override
    public String name();

    @Override
    public Optional<Semaphore> semaphore();

    @Override
    public Optional<Supplier<Long>> clock();

    @Override
    public boolean enableMetrics();

    public static class Builder
    extends BuilderBase<Builder, FixedLimitConfig>
    implements io.helidon.common.Builder<Builder, FixedLimit> {
        private Builder() {
        }

        public FixedLimitConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FixedLimitConfigImpl(this);
        }

        public FixedLimit build() {
            return FixedLimit.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FixedLimitConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enableMetrics = false;
        private boolean fair = false;
        private Config config;
        private Duration queueTimeout = Duration.parse("PT1S");
        private int permits = 0;
        private int queueLength = 0;
        private Semaphore semaphore;
        private String name = "fixed";
        private Supplier<Long> clock;

        protected BuilderBase() {
        }

        public BUILDER from(FixedLimitConfig prototype) {
            this.permits(prototype.permits());
            this.fair(prototype.fair());
            this.queueLength(prototype.queueLength());
            this.queueTimeout(prototype.queueTimeout());
            this.name(prototype.name());
            this.semaphore(prototype.semaphore());
            this.clock(prototype.clock());
            this.enableMetrics(prototype.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.permits(builder.permits());
            this.fair(builder.fair());
            this.queueLength(builder.queueLength());
            this.queueTimeout(builder.queueTimeout());
            this.name(builder.name());
            builder.semaphore().ifPresent(this::semaphore);
            builder.clock().ifPresent(this::clock);
            this.enableMetrics(builder.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("permits").as(Integer.class).ifPresent(this::permits);
            config.get("fair").as(Boolean.class).ifPresent(this::fair);
            config.get("queue-length").as(Integer.class).ifPresent(this::queueLength);
            config.get("queue-timeout").as(Duration.class).ifPresent(this::queueTimeout);
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER permits(int permits) {
            this.permits = permits;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fair(boolean fair) {
            this.fair = fair;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueLength(int queueLength) {
            this.queueLength = queueLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueTimeout(Duration queueTimeout) {
            Objects.requireNonNull(queueTimeout);
            this.queueTimeout = queueTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSemaphore() {
            this.semaphore = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER semaphore(Semaphore semaphore) {
            Objects.requireNonNull(semaphore);
            this.semaphore = semaphore;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClock() {
            this.clock = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clock(Supplier<Long> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int permits() {
            return this.permits;
        }

        public boolean fair() {
            return this.fair;
        }

        public int queueLength() {
            return this.queueLength;
        }

        public Duration queueTimeout() {
            return this.queueTimeout;
        }

        public String name() {
            return this.name;
        }

        public Optional<Semaphore> semaphore() {
            return Optional.ofNullable(this.semaphore);
        }

        public Optional<Supplier<Long>> clock() {
            return Optional.ofNullable(this.clock);
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "FixedLimitConfigBuilder{permits=" + this.permits + ",fair=" + this.fair + ",queueLength=" + this.queueLength + ",queueTimeout=" + String.valueOf(this.queueTimeout) + ",name=" + this.name + ",semaphore=" + String.valueOf(this.semaphore) + ",clock=" + String.valueOf(this.clock) + ",enableMetrics=" + this.enableMetrics + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER semaphore(Optional<? extends Semaphore> semaphore) {
            Objects.requireNonNull(semaphore);
            this.semaphore = semaphore.map(Semaphore.class::cast).orElse(this.semaphore);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER clock(Optional<Supplier<Long>> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock.map(Supplier.class::cast).orElse(this.clock);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class FixedLimitConfigImpl
        implements FixedLimitConfig,
        Supplier<FixedLimit> {
            private final boolean enableMetrics;
            private final boolean fair;
            private final Duration queueTimeout;
            private final int permits;
            private final int queueLength;
            private final Optional<Semaphore> semaphore;
            private final Optional<Supplier<Long>> clock;
            private final String name;

            protected FixedLimitConfigImpl(BuilderBase<?, ?> builder) {
                this.permits = builder.permits();
                this.fair = builder.fair();
                this.queueLength = builder.queueLength();
                this.queueTimeout = builder.queueTimeout();
                this.name = builder.name();
                this.semaphore = builder.semaphore().map(Function.identity());
                this.clock = builder.clock().map(Function.identity());
                this.enableMetrics = builder.enableMetrics();
            }

            public FixedLimit build() {
                return FixedLimit.create(this);
            }

            @Override
            public FixedLimit get() {
                return this.build();
            }

            @Override
            public int permits() {
                return this.permits;
            }

            @Override
            public boolean fair() {
                return this.fair;
            }

            @Override
            public int queueLength() {
                return this.queueLength;
            }

            @Override
            public Duration queueTimeout() {
                return this.queueTimeout;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<Semaphore> semaphore() {
                return this.semaphore;
            }

            @Override
            public Optional<Supplier<Long>> clock() {
                return this.clock;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            public String toString() {
                return "FixedLimitConfig{permits=" + this.permits + ",fair=" + this.fair + ",queueLength=" + this.queueLength + ",queueTimeout=" + String.valueOf(this.queueTimeout) + ",name=" + this.name + ",semaphore=" + String.valueOf(this.semaphore) + ",clock=" + String.valueOf(this.clock) + ",enableMetrics=" + this.enableMetrics + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FixedLimitConfig)) {
                    return false;
                }
                FixedLimitConfig other = (FixedLimitConfig)o;
                return this.permits == other.permits() && this.fair == other.fair() && this.queueLength == other.queueLength() && Objects.equals(this.queueTimeout, other.queueTimeout()) && Objects.equals(this.name, other.name()) && Objects.equals(this.semaphore, other.semaphore()) && Objects.equals(this.clock, other.clock()) && this.enableMetrics == other.enableMetrics();
            }

            public int hashCode() {
                return Objects.hash(this.permits, this.fair, this.queueLength, this.queueTimeout, this.name, this.semaphore, this.clock, this.enableMetrics);
            }
        }
    }
}

