/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.CalculatorState;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;

public class SimpleFeeCalculatorImpl
implements SimpleFeeCalculator {
    protected final FeeSchedule feeSchedule;
    private final Map<TransactionBody.DataOneOfType, ServiceFeeCalculator> serviceFeeCalculators;

    public SimpleFeeCalculatorImpl(FeeSchedule feeSchedule, Set<ServiceFeeCalculator> serviceFeeCalculators) {
        this.feeSchedule = feeSchedule;
        this.serviceFeeCalculators = serviceFeeCalculators.stream().collect(Collectors.toMap(ServiceFeeCalculator::getTransactionType, Function.identity()));
    }

    private void addNodeExtras(@NonNull FeeResult result, @NonNull Iterable<ExtraFeeReference> extras, long signatures) {
        for (ExtraFeeReference ref : extras) {
            long used = ref.name() == Extra.SIGNATURES ? signatures : 0L;
            if (used <= (long)ref.includedCount()) continue;
            long overage = used - (long)ref.includedCount();
            long unitFee = FeeScheduleUtils.lookupExtraFee((FeeSchedule)this.feeSchedule, (Extra)ref.name()).fee();
            result.addNodeFee(overage, unitFee);
        }
    }

    @Override
    @NonNull
    public FeeResult calculateTxFee(@NonNull TransactionBody txnBody, @Nullable CalculatorState calculatorState) {
        long signatures = calculatorState != null ? (long)calculatorState.numTxnSignatures() : 0L;
        FeeResult result = new FeeResult();
        result.addNodeFee(1L, this.feeSchedule.node().baseFee());
        this.addNodeExtras(result, this.feeSchedule.node().extras(), signatures);
        int multiplier = this.feeSchedule.network().multiplier();
        result.addNetworkFee(result.node * (long)multiplier);
        ServiceFeeCalculator serviceFeeCalculator = this.serviceFeeCalculators.get(txnBody.data().kind());
        serviceFeeCalculator.accumulateServiceFee(txnBody, calculatorState, result, this.feeSchedule);
        return result;
    }

    public static long countKeys(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1, Key.KeyOneOfType.ECDSA_384 -> 1L;
            case Key.KeyOneOfType.THRESHOLD_KEY -> key.thresholdKeyOrThrow().keys().keys().stream().mapToLong(SimpleFeeCalculatorImpl::countKeys).sum();
            case Key.KeyOneOfType.KEY_LIST -> key.keyListOrThrow().keys().stream().mapToLong(SimpleFeeCalculatorImpl::countKeys).sum();
            default -> 0L;
        };
    }

    @Override
    @NonNull
    public FeeResult calculateQueryFee(@NonNull Query query, @Nullable CalculatorState calculatorState) {
        throw new UnsupportedOperationException("Query fee calculation not supported for " + this.getClass().getSimpleName());
    }
}

