/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.calc;

import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.FeeObject;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class OverflowCheckingCalc {
    private static final String OVERFLOW_ERROR = "A fee calculation step overflowed; the operation cannot be priced, and therefore cannot be performed";

    @Inject
    public OverflowCheckingCalc() {
    }

    public FeeObject fees(UsageAccumulator usage, FeeData prices, ExchangeRate rate, long multiplier) {
        long networkFeeTinycents = this.networkFeeInTinycents(usage, prices.getNetworkdata());
        long nodeFeeTinycents = this.nodeFeeInTinycents(usage, prices.getNodedata());
        long serviceFeeTinycents = this.serviceFeeInTinycents(usage, prices.getServicedata());
        long unscaledNetworkFee = OverflowCheckingCalc.tinycentsToTinybars(networkFeeTinycents, rate);
        long unscaledNodeFee = OverflowCheckingCalc.tinycentsToTinybars(nodeFeeTinycents, rate);
        long unscaledServiceFee = OverflowCheckingCalc.tinycentsToTinybars(serviceFeeTinycents, rate);
        long maxUnscaled = Long.MAX_VALUE / multiplier;
        if (unscaledNetworkFee > maxUnscaled || unscaledNodeFee > maxUnscaled || unscaledServiceFee > maxUnscaled) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        return new FeeObject(unscaledNodeFee * multiplier, unscaledNetworkFee * multiplier, unscaledServiceFee * multiplier);
    }

    public static long tinycentsToTinybars(long amount, ExchangeRate rate) {
        int hbarEquiv = rate.getHbarEquiv();
        if (CommonUtils.productWouldOverflow((long)amount, (long)hbarEquiv)) {
            return FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)amount);
        }
        return amount * (long)hbarEquiv / (long)rate.getCentEquiv();
    }

    private long networkFeeInTinycents(UsageAccumulator usage, FeeComponents networkPrices) {
        long nominal = this.safeAccumulateThree(networkPrices.getConstant(), usage.getUniversalBpt() * networkPrices.getBpt(), usage.getNetworkVpt() * networkPrices.getVpt(), usage.getNetworkRbh() * networkPrices.getRbh());
        return this.constrainedTinycentFee(nominal, networkPrices.getMin(), networkPrices.getMax());
    }

    private long nodeFeeInTinycents(UsageAccumulator usage, FeeComponents nodePrices) {
        long nominal = this.safeAccumulateFour(nodePrices.getConstant(), usage.getUniversalBpt() * nodePrices.getBpt(), usage.getNodeBpr() * nodePrices.getBpr(), usage.getNodeSbpr() * nodePrices.getSbpr(), usage.getNodeVpt() * nodePrices.getVpt());
        return this.constrainedTinycentFee(nominal, nodePrices.getMin(), nodePrices.getMax());
    }

    private long serviceFeeInTinycents(UsageAccumulator usage, FeeComponents servicePrices) {
        long nominal = this.safeAccumulateThree(servicePrices.getConstant(), usage.getServiceRbh() * servicePrices.getRbh(), usage.getServiceSbh() * servicePrices.getSbh(), usage.getServiceGas() * servicePrices.getGas());
        return this.constrainedTinycentFee(nominal, servicePrices.getMin(), servicePrices.getMax());
    }

    private long constrainedTinycentFee(long nominal, long min, long max) {
        if (nominal < min) {
            nominal = min;
        } else if (nominal > max) {
            nominal = max;
        }
        return SingletonEstimatorUtils.ESTIMATOR_UTILS.nonDegenerateDiv(nominal, 1000);
    }

    long safeAccumulateFour(long base, long a, long b, long c, long d) {
        if (d < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        long sum = this.safeAccumulateThree(base, a, b, c);
        if ((sum += d) < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        return sum;
    }

    long safeAccumulateThree(long base, long a, long b, long c) {
        if (c < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        long sum = this.safeAccumulateTwo(base, a, b);
        if ((sum += c) < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        return sum;
    }

    long safeAccumulateTwo(long base, long a, long b) {
        if (base < 0L || a < 0L || b < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        if ((base += a) < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        if ((base += b) < 0L) {
            throw new IllegalArgumentException(OVERFLOW_ERROR);
        }
        return base;
    }
}

