/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.node.app.quiescence.BadMetadataException;
import com.hedera.node.app.quiescence.QuiescenceBlockTracker;
import com.hedera.node.app.quiescence.QuiescenceUtils;
import com.hedera.node.config.data.QuiescenceConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class QuiescenceController {
    private static final Logger logger = LogManager.getLogger(QuiescenceController.class);
    private final QuiescenceConfig config;
    private final InstantSource time;
    private final LongSupplier pendingTransactionCount;
    private final AtomicReference<Instant> nextTct;
    private final AtomicLong pipelineTransactionCount;
    private final Map<Long, QuiescenceBlockTracker> blockTrackers;
    @Nullable
    private QuiescenceBlockTracker inProgressBlockTracker;

    public QuiescenceController(@NonNull QuiescenceConfig config, @NonNull InstantSource time, @NonNull LongSupplier pendingTransactionCount) {
        this.config = Objects.requireNonNull(config);
        this.time = Objects.requireNonNull(time);
        this.pendingTransactionCount = Objects.requireNonNull(pendingTransactionCount);
        this.nextTct = new AtomicReference();
        this.pipelineTransactionCount = new AtomicLong(0L);
        this.blockTrackers = new ConcurrentHashMap<Long, QuiescenceBlockTracker>();
    }

    public void onPreHandle(@NonNull List<Transaction> transactions) {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.pipelineTransactionCount.addAndGet(QuiescenceUtils.countRelevantTransactions(transactions.iterator()));
        }
        catch (BadMetadataException e) {
            this.disableQuiescence(e);
        }
    }

    @Nullable
    public QuiescenceBlockTracker startingBlock(long blockNumber) {
        if (this.isDisabled()) {
            return null;
        }
        this.inProgressBlockTracker = new QuiescenceBlockTracker(blockNumber, this);
        return this.inProgressBlockTracker;
    }

    public void finishHandlingInProgressBlock() {
        if (this.isDisabled()) {
            return;
        }
        try {
            Objects.requireNonNull(this.inProgressBlockTracker).finishedHandlingTransactions();
        }
        catch (Exception e) {
            this.disableQuiescence(e);
        }
    }

    public void inProgressBlockTransaction(@NonNull ConsensusTransaction txn) {
        if (this.isDisabled()) {
            return;
        }
        try {
            Objects.requireNonNull(this.inProgressBlockTracker).blockTransaction((Transaction)txn);
            this.inProgressBlockTracker.consensusTimeAdvanced(txn.getConsensusTimestamp());
        }
        catch (Exception e) {
            this.disableQuiescence(e);
        }
    }

    public boolean switchTracker(long blockNumber) {
        if (this.isDisabled()) {
            return false;
        }
        boolean finishedPrevious = this.inProgressBlockTracker != null;
        this.startingBlock(blockNumber);
        return finishedPrevious;
    }

    void blockFinalized(@NonNull QuiescenceBlockTracker blockTracker) {
        if (this.isDisabled()) {
            return;
        }
        QuiescenceBlockTracker prevValue = this.blockTrackers.put(blockTracker.getBlockNumber(), blockTracker);
        if (prevValue != null) {
            this.disableQuiescence("Block %d was already finalized".formatted(blockTracker.getBlockNumber()));
        }
    }

    public void blockFullySigned(long blockNumber) {
        QuiescenceBlockTracker blockTracker = this.blockTrackers.remove(blockNumber);
        if (blockTracker == null) {
            this.disableQuiescence("Cannot find block tracker for block %d".formatted(blockNumber));
            return;
        }
        this.updateTransactionCount(-blockTracker.getRelevantTransactionCount());
        this.nextTct.accumulateAndGet(blockTracker.getMaxConsensusTime(), QuiescenceController::tctUpdate);
    }

    public void staleEvent(@NonNull Event event) {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.pipelineTransactionCount.addAndGet(-QuiescenceUtils.countRelevantTransactions(event.transactionIterator()));
        }
        catch (BadMetadataException e) {
            this.disableQuiescence(e);
        }
    }

    public void setNextTargetConsensusTime(@Nullable Instant targetConsensusTime) {
        if (this.isDisabled()) {
            return;
        }
        this.nextTct.set(targetConsensusTime);
    }

    public void platformStatusUpdate(@NonNull PlatformStatus platformStatus) {
        if (this.isDisabled()) {
            return;
        }
        if (platformStatus == PlatformStatus.RECONNECT_COMPLETE) {
            this.pipelineTransactionCount.set(0L);
            this.blockTrackers.clear();
        }
    }

    @NonNull
    public QuiescenceCommand getQuiescenceStatus() {
        if (this.isDisabled()) {
            return QuiescenceCommand.DONT_QUIESCE;
        }
        if (this.pipelineTransactionCount.get() > 0L) {
            return QuiescenceCommand.DONT_QUIESCE;
        }
        Instant tct = this.nextTct.get();
        if (tct != null && tct.minus(this.config.tctDuration()).isBefore(this.time.instant())) {
            return QuiescenceCommand.DONT_QUIESCE;
        }
        if (this.pendingTransactionCount.getAsLong() > 0L) {
            return QuiescenceCommand.BREAK_QUIESCENCE;
        }
        return QuiescenceCommand.QUIESCE;
    }

    void disableQuiescence(@NonNull String reason) {
        this.disableQuiescence();
        logger.error("Disabling quiescence, reason: {}", (Object)reason);
    }

    void disableQuiescence(@NonNull Exception exception) {
        this.disableQuiescence();
        logger.error("Disabling quiescence due to exception:", (Throwable)exception);
    }

    boolean isDisabled() {
        return !this.config.enabled() || this.pipelineTransactionCount.get() < 0L;
    }

    private void disableQuiescence() {
        this.pipelineTransactionCount.set(-4611686018427387904L);
    }

    private static Instant tctUpdate(@Nullable Instant currentTct, @NonNull Instant currentConsensusTime) {
        if (currentTct == null) {
            return null;
        }
        return currentConsensusTime.isAfter(currentTct) ? null : currentTct;
    }

    private void updateTransactionCount(long delta) {
        long updatedValue = this.pipelineTransactionCount.addAndGet(delta);
        if (updatedValue < 0L) {
            this.disableQuiescence("Quiescence transaction count is negative, this indicates a bug");
        }
    }
}

