/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

public class CollectingObserver<T, V, U, A, R>
implements StreamObserver<V> {
    private final Collector<T, A, R> collector;
    private final StreamObserver<U> responseObserver;
    private final Function<V, T> requestConverter;
    private final Function<R, U> responseConverter;
    private final Consumer<Throwable> errorHandler;
    private final A accumulator;

    public static <T, V, U, A, R> CollectingObserver<T, V, U, A, R> create(Collector<T, A, R> collector, StreamObserver<U> observer) {
        return new CollectingObserver<T, V, U, A, R>(collector, observer, null, null, null);
    }

    public static <T, V, U, A, R> CollectingObserver<T, V, U, A, R> create(Collector<T, A, R> collector, StreamObserver<U> observer, Consumer<Throwable> errorHandler) {
        Objects.requireNonNull(errorHandler);
        return new CollectingObserver<T, V, U, A, R>(collector, observer, null, null, errorHandler);
    }

    public static <T, V, U, A, R> CollectingObserver<T, V, U, A, R> create(Collector<T, A, R> collector, StreamObserver<U> observer, Function<V, T> requestConverter, Function<R, U> responseConverter) {
        Objects.requireNonNull(requestConverter);
        Objects.requireNonNull(responseConverter);
        return new CollectingObserver<T, V, U, A, R>(collector, observer, requestConverter, responseConverter, null);
    }

    private CollectingObserver(Collector<T, A, R> collector, StreamObserver<U> observer, Function<V, T> requestConverter, Function<R, U> responseConverter, Consumer<Throwable> errorHandler) {
        this.collector = Objects.requireNonNull(collector, "The collector parameter cannot be null");
        this.responseObserver = Objects.requireNonNull(observer, "The observer parameter cannot be null");
        this.requestConverter = Optional.ofNullable(requestConverter).orElse(v -> v);
        this.responseConverter = Optional.ofNullable(responseConverter).orElse(r -> r);
        this.errorHandler = Optional.ofNullable(errorHandler).orElse(t -> {});
        this.accumulator = collector.supplier().get();
    }

    public void onNext(V value) {
        this.collector.accumulator().accept(this.accumulator, this.requestConverter.apply(value));
    }

    public void onError(Throwable t) {
        this.errorHandler.accept(t);
    }

    public void onCompleted() {
        R result = this.collector.finisher().apply(this.accumulator);
        this.responseObserver.onNext(this.responseConverter.apply(result));
        this.responseObserver.onCompleted();
    }
}

