/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.ServiceRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RegistryBuilderSupport {
    private RegistryBuilderSupport() {
    }

    public static <T> List<T> serviceList(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry) {
        return RegistryBuilderSupport.serviceList(registry, contract, useRegistry, Optional.empty());
    }

    public static <T> List<T> serviceList(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry, Optional<String> namedQualifier) {
        if (!useRegistry) {
            return List.of();
        }
        return RegistryBuilderSupport.lookupAll(registry, contract, namedQualifier);
    }

    public static <T> Set<T> serviceSet(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry) {
        return RegistryBuilderSupport.serviceSet(registry, contract, useRegistry, Optional.empty());
    }

    public static <T> Set<T> serviceSet(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry, Optional<String> namedQualifier) {
        if (!useRegistry) {
            return Set.of();
        }
        return Set.copyOf(RegistryBuilderSupport.lookupAll(registry, contract, namedQualifier));
    }

    public static <T> Optional<T> service(Optional<ServiceRegistry> registry, TypeName contract, Optional<T> existingValue, boolean useRegistry) {
        return RegistryBuilderSupport.service(registry, contract, existingValue, useRegistry, Optional.empty());
    }

    public static <T> Optional<T> service(Optional<ServiceRegistry> registry, TypeName contract, Optional<T> existingValue, boolean useRegistry, Optional<String> namedQualifier) {
        if (existingValue.isPresent() || !useRegistry) {
            return existingValue;
        }
        if (namedQualifier.isEmpty()) {
            return registry.orElseGet(GlobalServiceRegistry::registry).first(contract);
        }
        return namedQualifier.map(Qualifier::createNamed).map(qualifier -> ((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).addQualifier((Qualifier)qualifier)).build()).flatMap(l -> registry.orElseGet(GlobalServiceRegistry::registry).first((Lookup)l));
    }

    private static <T> List<T> lookupAll(Optional<ServiceRegistry> registry, TypeName contract, Optional<String> namedQualifier) {
        if (namedQualifier.isEmpty()) {
            return registry.orElseGet(GlobalServiceRegistry::registry).all(contract);
        }
        return namedQualifier.map(Qualifier::createNamed).map(qualifier -> ((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).addQualifier((Qualifier)qualifier)).build()).map(value -> registry.orElseGet(GlobalServiceRegistry::registry).all((Lookup)value)).orElseGet(List::of);
    }
}

