/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.cancelairdrops;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.cancelairdrops.TokenCancelAirdropDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenCancelAirdropTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod CANCEL_AIRDROPS = SystemContractMethod.declare("cancelAirdrops((address,address,address,int64)[])", "(int64)").withCategories(SystemContractMethod.Category.AIRDROP);
    public static final SystemContractMethod HRC_CANCEL_AIRDROP_FT = SystemContractMethod.declare("cancelAirdropFT(address)", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.AIRDROP);
    public static final SystemContractMethod HRC_CANCEL_AIRDROP_NFT = SystemContractMethod.declare("cancelAirdropNFT(address,int64)", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.AIRDROP);
    private final TokenCancelAirdropDecoder decoder;

    @Inject
    public TokenCancelAirdropTranslator(@NonNull TokenCancelAirdropDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        Objects.requireNonNull(decoder);
        this.decoder = decoder;
        this.registerMethods(CANCEL_AIRDROPS, HRC_CANCEL_AIRDROP_FT, HRC_CANCEL_AIRDROP_NFT);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        boolean cancelAirdropEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractCancelAirdropsEnabled();
        if (!cancelAirdropEnabled) {
            return Optional.empty();
        }
        return attempt.isRedirect() ? attempt.isMethod(HRC_CANCEL_AIRDROP_FT, HRC_CANCEL_AIRDROP_NFT) : attempt.isMethod(CANCEL_AIRDROPS);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyFor(attempt), TokenCancelAirdropTranslator::gasRequirement);
    }

    private TransactionBody bodyFor(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(CANCEL_AIRDROPS)) {
            return this.decoder.decodeCancelAirdrop(attempt);
        }
        if (attempt.isSelector(HRC_CANCEL_AIRDROP_FT)) {
            return this.decoder.decodeCancelAirdropFT(attempt);
        }
        return this.decoder.decodeCancelAirdropNFT(attempt);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.TOKEN_CANCEL_AIRDROP, payerId);
    }
}

