/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.hapi.utils.ethereum.EthTxSigs;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EthTxSigsCache {
    private static final int ETH_SIGS_CACHE_TTL_SECS = 15;
    private final LoadingCache<EthTxData, EthTxSigs> cache = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).softValues().build(EthTxSigs::extractSignatures);

    @Inject
    public EthTxSigsCache() {
    }

    public EthTxSigs computeIfAbsent(@NonNull EthTxData data) {
        return (EthTxSigs)this.cache.get((Object)data);
    }
}

