/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces;

import com.swirlds.common.utility.UnmodifiableIterator;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.structures.RandomAccessDeque;
import org.hiero.consensus.pces.PcesFile;
import org.hiero.consensus.pces.PcesMultiFileIterator;

public class PcesFileTracker {
    private static final Logger logger = LogManager.getLogger(PcesFileTracker.class);
    private static final int INITIAL_RING_BUFFER_SIZE = 1024;
    private final RandomAccessDeque<PcesFile> files = new RandomAccessDeque(1024);

    public PcesFile getFirstFile() {
        return (PcesFile)this.files.getFirst();
    }

    public PcesFile getLastFile() {
        return (PcesFile)this.files.getLast();
    }

    public PcesFile removeFirstFile() {
        return (PcesFile)this.files.removeFirst();
    }

    public PcesFile removeLastFile() {
        return (PcesFile)this.files.removeLast();
    }

    public int getFileCount() {
        return this.files.size();
    }

    public long getTotalFileByteCount() throws IOException {
        long totalFileByteCount = 0L;
        for (PcesFile file : this.files) {
            totalFileByteCount += Files.size(file.getPath());
        }
        return totalFileByteCount;
    }

    public void addFile(@NonNull PcesFile file) {
        Objects.requireNonNull(file);
        this.files.addLast((Object)file);
    }

    @NonNull
    public PcesFile getFile(int index) {
        return (PcesFile)this.files.get(index);
    }

    public void setFile(int index, @NonNull PcesFile file) {
        Objects.requireNonNull(file);
        this.files.set(index, (Object)file);
    }

    @NonNull
    public PcesMultiFileIterator getEventIterator(long lowerBound, long startingRound) {
        return new PcesMultiFileIterator(lowerBound, this.getFileIterator(lowerBound, startingRound));
    }

    @NonNull
    public Iterator<PcesFile> getFileIterator(long lowerBound, long originRound) {
        int firstFileIndex = this.getFirstRelevantFileIndex(originRound);
        if (lowerBound == -1L) {
            return new UnmodifiableIterator(this.files.iterator(firstFileIndex));
        }
        if (this.files.size() == 0) {
            logger.warn(LogMarker.STARTUP.getMarker(), "No preconsensus event files available");
            return Collections.emptyIterator();
        }
        if (((PcesFile)this.files.get(firstFileIndex)).getLowerBound() >= lowerBound) {
            logger.warn(LogMarker.STARTUP.getMarker(), "The preconsensus event stream has insufficient data to guarantee that all events with the requested lower bound of {} are present, the first file has a lower bound of {}", (Object)lowerBound, (Object)((PcesFile)this.files.get(firstFileIndex)).getLowerBound());
            return new UnmodifiableIterator(this.files.iterator(firstFileIndex));
        }
        if (((PcesFile)this.files.getLast()).getUpperBound() < lowerBound) {
            logger.warn(LogMarker.STARTUP.getMarker(), "The preconsensus event stream has insufficient data to guarantee that all events with the requested lower bound of {} are present, the last file has a lower bound of {}", (Object)lowerBound, (Object)((PcesFile)this.files.getLast()).getUpperBound());
            return Collections.emptyIterator();
        }
        int fileCount = this.files.size();
        for (int index = firstFileIndex; index < fileCount; ++index) {
            PcesFile file = (PcesFile)this.files.get(index);
            if (file.getUpperBound() < lowerBound) continue;
            return new UnmodifiableIterator(this.files.iterator(index));
        }
        throw new IllegalStateException("Failed to find a file that may contain events at the requested lower bound");
    }

    public Iterator<PcesFile> getFileIterator() {
        return new UnmodifiableIterator(this.files.iterator());
    }

    public int getFirstRelevantFileIndex(long originRound) {
        int candidateIndex = -1;
        long candidateOrigin = -1L;
        for (int index = 0; index < this.files.size(); ++index) {
            long fileOrigin = ((PcesFile)this.files.get(index)).getOrigin();
            if (fileOrigin > originRound) {
                return candidateIndex;
            }
            if (fileOrigin <= candidateOrigin) continue;
            candidateIndex = index;
            candidateOrigin = fileOrigin;
        }
        return candidateIndex;
    }
}

