/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.hooks.EvmHookMappingEntries;
import com.hedera.hapi.node.hooks.EvmHookMappingEntry;
import com.hedera.hapi.node.hooks.EvmHookStorageSlot;
import com.hedera.hapi.node.hooks.EvmHookStorageUpdate;
import com.hedera.hapi.node.hooks.HookStoreTransactionBody;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.hooks.HookType;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.ReadableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

@Singleton
public class HookStoreHandler
implements TransactionHandler {
    private static final long TINYCENTS_PER_UPDATE = 50000000L;
    public static final long MAX_UPDATE_BYTES_LEN = 32L;

    @Inject
    public HookStoreHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        HookStoreTransactionBody op = context.body().hookStoreOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasHookId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookId hookId = op.hookIdOrThrow();
        PreCheckException.validateTruePreCheck((boolean)hookId.hasEntityId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        HookEntityId.EntityIdOneOfType ownerType = (HookEntityId.EntityIdOneOfType)hookId.entityIdOrThrow().entityId().kind();
        PreCheckException.validateTruePreCheck((ownerType != HookEntityId.EntityIdOneOfType.UNSET ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_ID);
        PreCheckException.validateFalsePreCheck((boolean)op.storageUpdates().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.EMPTY_EVM_HOOK_STORAGE_UPDATE);
        for (EvmHookStorageUpdate update : op.storageUpdates()) {
            if (update.hasStorageSlot()) {
                this.validateSlot(update.storageSlotOrThrow());
                continue;
            }
            if (update.hasMappingEntries()) {
                EvmHookMappingEntries mappingEntries = update.mappingEntriesOrThrow();
                this.validateWord(mappingEntries.mappingSlot());
                for (EvmHookMappingEntry entry : mappingEntries.entries()) {
                    this.validateEntry(entry);
                }
                continue;
            }
            throw new PreCheckException(ResponseCodeEnum.EMPTY_EVM_HOOK_STORAGE_UPDATE);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        HookStoreTransactionBody op = context.body().hookStoreOrThrow();
        ReadableEvmHookStore store = (ReadableEvmHookStore)context.createStore(ReadableEvmHookStore.class);
        HookId hookId = HookStoreHandler.effectiveHookId(op.hookIdOrThrow());
        EvmHookState hook = store.getEvmHook(hookId);
        PreCheckException.validateTruePreCheck((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
        PreCheckException.validateTruePreCheck((hook.type() == HookType.EVM_HOOK ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_IS_NOT_AN_EVM_HOOK);
        AccountID ownerAccountId = hookId.entityIdOrThrow().accountIdOrThrow();
        if (hook.hasAdminKey()) {
            context.requireKeyOrThrow(ownerAccountId, ownerKey -> Key.newBuilder().thresholdKey(ThresholdKey.newBuilder().threshold(1).keys(new KeyList(List.of(ownerKey, hook.adminKeyOrThrow())))).build(), ResponseCodeEnum.INVALID_HOOK_ID);
        } else {
            context.requireKeyOrThrowOnDeleted(ownerAccountId, ResponseCodeEnum.INVALID_HOOK_ID);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        HookStoreTransactionBody op = context.body().hookStoreOrThrow();
        WritableEvmHookStore evmHookStore = (WritableEvmHookStore)context.storeFactory().writableStore(WritableEvmHookStore.class);
        List storageUpdates = op.storageUpdates();
        HooksConfig config = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleException.validateTrue((storageUpdates.size() <= config.maxHookStoreUpdates() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOO_MANY_EVM_HOOK_STORAGE_UPDATES);
        HookId hookId = HookStoreHandler.effectiveHookId(op.hookIdOrThrow());
        int delta = evmHookStore.updateStorage(hookId, op.storageUpdates());
        HandleException.validateTrue((evmHookStore.numStorageSlotsInState() <= config.maxEvmHookStorageSlots() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED);
        TokenServiceApi tokenServiceApi = (TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.updateHookStorageSlots(hookId.entityIdOrThrow().accountIdOrThrow(), delta, op.hookIdOrThrow().entityIdOrThrow().hasContractId());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        com.hedera.node.app.spi.fees.FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        HookStoreTransactionBody op = feeContext.body().hookStoreOrThrow();
        int n = HookStoreHandler.slotCount(op.storageUpdates());
        long p = feeContext.getGasPriceInTinycents();
        return calculator.addGas(((long)n * 50000000L + (p - 1L)) / p).calculate();
    }

    private static int slotCount(@NonNull List<EvmHookStorageUpdate> storageUpdates) {
        int count = 0;
        for (EvmHookStorageUpdate update : storageUpdates) {
            if (update.hasStorageSlot()) {
                ++count;
                continue;
            }
            if (!update.hasMappingEntries()) continue;
            count += update.mappingEntriesOrThrow().entries().size();
        }
        return count;
    }

    private void validateSlot(@NonNull EvmHookStorageSlot slot) throws PreCheckException {
        this.validateWord(slot.key());
        this.validateWord(slot.value());
    }

    private void validateEntry(@NonNull EvmHookMappingEntry entry) throws PreCheckException {
        this.validateWord(entry.value());
    }

    private void validateWord(@NonNull Bytes bytes) throws PreCheckException {
        PreCheckException.validateTruePreCheck((bytes.length() <= 32L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EVM_HOOK_STORAGE_UPDATE_BYTES_TOO_LONG);
        Bytes minimalBytes = HookUtils.minimalRepresentationOf((Bytes)bytes);
        PreCheckException.validateTruePreCheck((bytes == minimalBytes ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EVM_HOOK_STORAGE_UPDATE_BYTES_MUST_USE_MINIMAL_REPRESENTATION);
    }

    private static HookId effectiveHookId(@NonNull HookId hookId) {
        HookEntityId entityId = hookId.entityIdOrThrow();
        return entityId.hasContractId() ? HookId.newBuilder().entityId(HookEntityId.newBuilder().accountId(HookUtils.asAccountId((ContractID)entityId.contractIdOrThrow()))).hookId(hookId.hookId()).build() : hookId;
    }

    public static class FeeCalculator
    implements ServiceFeeCalculator {
        public TransactionBody.DataOneOfType getTransactionType() {
            return TransactionBody.DataOneOfType.HOOK_STORE;
        }

        public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
            Objects.requireNonNull(txnBody);
            Objects.requireNonNull(feeResult);
            Objects.requireNonNull(feeSchedule);
            ServiceFeeDefinition fee = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.HOOK_STORE);
            Objects.requireNonNull(fee);
            HookStoreTransactionBody op = txnBody.hookStoreOrThrow();
            feeResult.addServiceFee((long)HookStoreHandler.slotCount(op.storageUpdates()), fee.baseFee());
        }
    }
}

