/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.node.app.hapi.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;

public class FeeResult {
    public long service = 0L;
    public long node = 0L;
    public long network = 0L;
    public List<FeeDetail> details = new ArrayList<FeeDetail>();

    public void addServiceFee(long count, long cost) {
        this.details.add(new FeeDetail(count, cost));
        this.service = FeeResult.clampedAdd(this.service, CommonUtils.clampedMultiply((long)count, (long)cost));
    }

    public void addNodeFee(long count, long cost) {
        this.details.add(new FeeDetail(count, cost));
        this.node = FeeResult.clampedAdd(this.node, CommonUtils.clampedMultiply((long)count, (long)cost));
    }

    public void addNetworkFee(long cost) {
        this.details.add(new FeeDetail(1L, cost));
        this.network = FeeResult.clampedAdd(this.network, cost);
    }

    public long total() {
        return FeeResult.clampedAdd(FeeResult.clampedAdd(this.node, this.network), this.service);
    }

    public String toString() {
        return "FeeResult{fee=" + this.total() + ", details=" + String.valueOf(this.details) + "}";
    }

    private static long clampedAdd(long a, long b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException ae) {
            return a > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public static class FeeDetail {
        public long count;
        public long fee;

        public FeeDetail(long count, long fee) {
            this.count = count;
            this.fee = fee;
        }

        public String toString() {
            return "FeeDetail{" + this.count + ", " + this.fee + "}";
        }
    }
}

