/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.forensics;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.hapi.utils.forensics.DifferingEntries;
import com.hedera.node.app.hapi.utils.forensics.RecordParsers;
import com.hedera.node.app.hapi.utils.forensics.RecordStreamEntry;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class OrderedComparison {
    private static final Predicate<RecordStreamEntry> DEFAULT_ENTRY_INCLUSION_TEST = e -> true;
    private static final Predicate<String> DEFAULT_FILENAME_INCLUSION_TEST = filename -> true;

    private OrderedComparison() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static List<DifferingEntries> findDifferencesBetweenV6(@NonNull String firstStreamDir, @NonNull String secondStreamDir, @Nullable RecordDiffSummarizer recordDiffSummarizer, @Nullable Predicate<String> maybeInclusionTest, @Nullable String maybeInclusionDescription) throws IOException {
        Predicate<String> inclusionTest = maybeInclusionTest == null ? DEFAULT_FILENAME_INCLUSION_TEST : maybeInclusionTest;
        String inclusionDescription = maybeInclusionDescription == null ? "all" : maybeInclusionDescription;
        System.out.println("Parsing stream @ " + firstStreamDir + " (including " + inclusionDescription + ")");
        List<RecordStreamEntry> firstEntries = RecordParsers.parseV6RecordStreamEntriesIn(firstStreamDir, inclusionTest);
        System.out.println(" \u27a1\ufe0f  Read " + firstEntries.size() + " entries");
        System.out.println("Parsing stream @ " + secondStreamDir + " (including " + inclusionDescription + ")");
        List<RecordStreamEntry> secondEntries = RecordParsers.parseV6RecordStreamEntriesIn(secondStreamDir, inclusionTest);
        System.out.println(" \u27a1\ufe0f  Read " + secondEntries.size() + " entries");
        return OrderedComparison.findDifferencesBetweenV6(firstEntries, secondEntries, recordDiffSummarizer, null);
    }

    public static List<DifferingEntries> findDifferencesBetweenV6(@NonNull List<RecordStreamEntry> firstEntries, @NonNull List<RecordStreamEntry> secondEntries, @Nullable RecordDiffSummarizer recordDiffSummarizer, @Nullable Predicate<RecordStreamEntry> maybeInclusionTest) {
        Predicate<RecordStreamEntry> inclusionTest = maybeInclusionTest == null ? DEFAULT_ENTRY_INCLUSION_TEST : maybeInclusionTest;
        List<RecordStreamEntry> filteredFirst = firstEntries.stream().filter(inclusionTest).toList();
        List<RecordStreamEntry> filteredSecond = secondEntries.stream().filter(inclusionTest).toList();
        CompareList compareList = OrderedComparison.getCompareList(filteredFirst, filteredSecond);
        return OrderedComparison.diff(compareList.firstList, compareList.secondList, recordDiffSummarizer);
    }

    @NonNull
    private static CompareList getCompareList(List<RecordStreamEntry> firstEntries, List<RecordStreamEntry> secondEntries) {
        CompareList ret;
        ArrayList<RecordStreamEntry> firstList = new ArrayList<RecordStreamEntry>();
        ArrayList<RecordStreamEntry> secondList = new ArrayList<RecordStreamEntry>();
        if (secondEntries.isEmpty() || firstEntries.isEmpty()) {
            ret = new CompareList(firstEntries, secondEntries);
        } else {
            int k;
            int firstIdx = 0;
            int secondIdx = 0;
            while (firstIdx < firstEntries.size() && secondIdx < secondEntries.size()) {
                if (firstEntries.get(firstIdx).consensusTime().equals(secondEntries.get(secondIdx).consensusTime())) {
                    firstList.add(firstEntries.get(firstIdx));
                    secondList.add(secondEntries.get(secondIdx));
                    ++firstIdx;
                    ++secondIdx;
                    continue;
                }
                if (firstEntries.get(firstIdx).consensusTime().isBefore(secondEntries.get(secondIdx).consensusTime())) {
                    firstList.add(firstEntries.get(firstIdx));
                    secondList.add(new RecordStreamEntry(null, null, firstEntries.get(firstIdx).consensusTime()));
                    ++firstIdx;
                    continue;
                }
                firstList.add(new RecordStreamEntry(null, null, secondEntries.get(secondIdx).consensusTime()));
                secondList.add(secondEntries.get(secondIdx));
                ++secondIdx;
            }
            if (firstIdx < firstEntries.size()) {
                for (k = firstIdx; k < firstEntries.size(); ++k) {
                    firstList.add(firstEntries.get(k));
                    secondList.add(new RecordStreamEntry(null, null, firstEntries.get(k).consensusTime()));
                }
            }
            if (secondIdx < secondEntries.size()) {
                for (k = secondIdx; k < secondEntries.size(); ++k) {
                    firstList.add(new RecordStreamEntry(null, null, secondEntries.get(k).consensusTime()));
                    secondList.add(secondEntries.get(k));
                }
            }
            ret = new CompareList(firstList, secondList);
        }
        return ret;
    }

    @VisibleForTesting
    static List<DifferingEntries> diff(@NonNull List<RecordStreamEntry> firstEntries, @NonNull List<RecordStreamEntry> secondEntries, @Nullable RecordDiffSummarizer recordDiffSummarizer) {
        Objects.requireNonNull(firstEntries);
        Objects.requireNonNull(secondEntries);
        ArrayList<DifferingEntries> diffs = new ArrayList<DifferingEntries>();
        int minSize = Math.min(firstEntries.size(), secondEntries.size());
        for (int i = 0; i < minSize; ++i) {
            RecordStreamEntry firstEntry = firstEntries.get(i);
            try {
                if (secondEntries.get(i).txnRecord() == null) {
                    diffs.add(new DifferingEntries(firstEntry, null, "No first/test stream record found at " + String.valueOf(firstEntry.consensusTime()) + " for transactionID : " + String.valueOf(firstEntry.txnRecord().getTransactionID()) + " transBody : " + String.valueOf(firstEntry.body())));
                    continue;
                }
                if (firstEntries.get(i).txnRecord() == null) {
                    diffs.add(new DifferingEntries(null, secondEntries.get(i), "Additional first/test stream record found at " + String.valueOf(secondEntries.get(i).consensusTime()) + " for transactionID : " + String.valueOf(secondEntries.get(i).txnRecord().getTransactionID()) + " transBody : " + String.valueOf(secondEntries.get(i).body()) + "\n -> \n" + String.valueOf(secondEntries.get(i).txnRecord())));
                    continue;
                }
                RecordStreamEntry secondEntry = OrderedComparison.entryWithMatchableRecord(secondEntries, i, firstEntry);
                if (firstEntry.txnRecord().equals((Object)secondEntry.txnRecord())) continue;
                String summary = recordDiffSummarizer == null ? null : (String)recordDiffSummarizer.apply(firstEntry.txnRecord(), secondEntry.txnRecord());
                diffs.add(new DifferingEntries(firstEntry, secondEntry, summary));
                continue;
            }
            catch (UnmatchableException e) {
                diffs.add(new DifferingEntries(firstEntry, secondEntries.get(i), e.getMessage()));
            }
        }
        if (firstEntries.size() != secondEntries.size()) {
            OrderedComparison.appendExtraEntriesFrom(firstEntries, secondEntries, minSize, diffs);
        }
        return diffs;
    }

    public static Map<HederaFunctionality, Map<ResponseCodeEnum, Integer>> statusHistograms(List<RecordStreamEntry> entries) {
        EnumMap<HederaFunctionality, Map<ResponseCodeEnum, Integer>> counts = new EnumMap<HederaFunctionality, Map<ResponseCodeEnum, Integer>>(HederaFunctionality.class);
        for (RecordStreamEntry entry : entries) {
            counts.computeIfAbsent(entry.parts().function(), ignore -> new EnumMap(ResponseCodeEnum.class)).merge(entry.finalStatus(), 1, Integer::sum);
        }
        return counts;
    }

    public static List<RecordStreamEntry> filterByFunction(List<RecordStreamEntry> entries, HederaFunctionality function) {
        return entries.stream().filter(entry -> entry.function() == function).toList();
    }

    @NonNull
    private static RecordStreamEntry entryWithMatchableRecord(@NonNull List<RecordStreamEntry> entries, int index, @NonNull RecordStreamEntry entryToMatch) throws UnmatchableException {
        RecordStreamEntry secondEntry = entries.get(index);
        if (!entryToMatch.consensusTime().equals(secondEntry.consensusTime())) {
            throw new UnmatchableException("Entries at position " + index + " had different consensus times (" + String.valueOf(entryToMatch.consensusTime()) + " vs " + String.valueOf(secondEntry.consensusTime()) + ")");
        }
        if (!entryToMatch.submittedTransaction().equals((Object)secondEntry.submittedTransaction())) {
            throw new UnmatchableException("Entries at position " + index + " had different transactions (" + String.valueOf(entryToMatch.submittedTransaction()) + " vs " + String.valueOf(secondEntry.submittedTransaction()) + ")");
        }
        return secondEntry;
    }

    private static void appendExtraEntriesFrom(@NonNull List<RecordStreamEntry> firstEntries, @NonNull List<RecordStreamEntry> secondEntries, int minSize, @NonNull List<DifferingEntries> diffs) {
        boolean firstHasExtra = firstEntries.size() > secondEntries.size();
        List<RecordStreamEntry> extraEntries = firstHasExtra ? firstEntries.subList(minSize, firstEntries.size()) : secondEntries.subList(minSize, secondEntries.size());
        int maxSize = Math.max(firstEntries.size(), secondEntries.size());
        for (int i = minSize; i < maxSize; ++i) {
            String summary = firstHasExtra ? "Extra entry at index " + i + " from first stream" : "Extra entry at index " + i + " from second stream";
            RecordStreamEntry extraEntry = extraEntries.get(i - minSize);
            diffs.add(new DifferingEntries(firstHasExtra ? extraEntry : null, firstHasExtra ? null : extraEntry, summary));
        }
    }

    public static interface RecordDiffSummarizer
    extends BiFunction<TransactionRecord, TransactionRecord, String> {
    }

    record CompareList(@NonNull List<RecordStreamEntry> firstList, @NonNull List<RecordStreamEntry> secondList) {
    }

    private static class UnmatchableException
    extends Exception {
        UnmatchableException(@NonNull String message) {
            super(message);
        }
    }
}

