/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.structures;

import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.structures.RandomAccessDeque;

public class SequentialRingBuffer<T> {
    private static final Logger logger = LogManager.getLogger(SequentialRingBuffer.class);
    private static final int DEFAULT_CAPACITY = 1000;
    private final RandomAccessDeque<T> elements;
    private long minIndex;

    public SequentialRingBuffer(long startingIndex, int initialCapacity) {
        this.elements = new RandomAccessDeque(initialCapacity);
        this.minIndex = startingIndex;
    }

    public SequentialRingBuffer(long startingIndex) {
        this(startingIndex, 1000);
    }

    public void reset(long minIndex) {
        this.elements.clear();
        this.minIndex = minIndex;
    }

    public boolean exists(long index) {
        return index >= this.minIndex && index < this.nextIndex();
    }

    public void add(long index, @Nullable T element) {
        if (index < this.minIndex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SequentialRingBuffer.add called for an old, discarded index. Index requested:{}, Min index:{}, Next index:{} ", (Object)index, (Object)this.minIndex, (Object)this.nextIndex());
            return;
        }
        if (index < this.nextIndex()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SequentialRingBuffer.add called for an existing index. Index requested:{}, Min index:{}, Next index:{} ", (Object)index, (Object)this.minIndex, (Object)this.nextIndex());
            this.elements.set(this.dequeIndex(index), element);
            return;
        }
        if (index != this.nextIndex()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SequentialRingBuffer.add called for a index that is not the next one. Index requested:{}, Min index:{}, Next index:{} ", (Object)index, (Object)this.minIndex, (Object)this.nextIndex());
            for (long i = this.nextIndex(); i < index; ++i) {
                this.elements.addLast(null);
            }
            this.elements.addLast(element);
            return;
        }
        this.elements.addLast(element);
    }

    public void removeNewerThan(long index) {
        for (long i = this.maxIndex(); i > index && this.exists(i); --i) {
            this.elements.removeLast();
        }
    }

    public void removeOlderThan(long index) {
        while (this.minIndex < index && this.minIndex <= this.maxIndex()) {
            this.elements.removeFirst();
            ++this.minIndex;
        }
    }

    @Nullable
    public T get(long index) {
        if (this.exists(index)) {
            return this.elements.get(this.dequeIndex(index));
        }
        return null;
    }

    @Nullable
    public T getLatest() {
        return this.get(this.maxIndex());
    }

    public long minIndex() {
        return this.minIndex;
    }

    public long maxIndex() {
        return this.nextIndex() - 1L;
    }

    public long nextIndex() {
        return this.minIndex + (long)this.elements.size();
    }

    private int dequeIndex(long index) {
        long dequeIndex = index - this.minIndex;
        if ((long)((int)dequeIndex) != dequeIndex) {
            return 0;
        }
        return (int)dequeIndex;
    }
}

