/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.app.blocks.impl.BlockStreamBuilder;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.blocks.impl.PairedStreamBuilder;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.ReadonlyStatesWrapper;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.app.state.WrappedState;
import com.hedera.node.app.state.recordcache.BlockRecordSource;
import com.hedera.node.app.state.recordcache.LegacyListRecordSource;
import com.hedera.node.app.workflows.handle.HandleOutput;
import com.hedera.node.app.workflows.handle.record.RecordStreamBuilder;
import com.hedera.node.app.workflows.handle.stack.BuilderSink;
import com.hedera.node.app.workflows.handle.stack.Savepoint;
import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.hedera.node.app.workflows.handle.stack.savepoints.BuilderSinkImpl;
import com.hedera.node.app.workflows.handle.stack.savepoints.FirstChildSavepoint;
import com.hedera.node.app.workflows.handle.stack.savepoints.FirstRootSavepoint;
import com.hedera.node.app.workflows.handle.stack.savepoints.FollowingSavepoint;
import com.hedera.node.config.types.StreamMode;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.base.crypto.Hash;

public class SavepointStackImpl
implements HandleContext.SavepointStack,
State {
    private final State state;
    private final Deque<Savepoint> stack = new ArrayDeque<Savepoint>();
    private final Map<String, WritableStatesStack> writableStatesMap = new HashMap<String, WritableStatesStack>();
    private final StreamBuilder baseBuilder;
    @Nullable
    private final BuilderSink builderSink;
    @Nullable
    private final ImmediateStateChangeListener immediateStateChangeListener;
    @Nullable
    private final BoundaryStateChangeListener boundaryStateChangeListener;
    private final StreamMode streamMode;
    private int numPresetIds;
    private int noncesToSkipPerPresetId;
    private boolean presetIdsAllowed;

    public static SavepointStackImpl newRootStack(@NonNull State state, int maxBuildersBeforeUser, int maxBuildersAfterUser, @NonNull BoundaryStateChangeListener boundaryStateChangeListener, @NonNull ImmediateStateChangeListener immediateStateChangeListener, @NonNull StreamMode streamMode) {
        return new SavepointStackImpl(state, maxBuildersBeforeUser, maxBuildersAfterUser, boundaryStateChangeListener, immediateStateChangeListener, streamMode);
    }

    public static SavepointStackImpl newChildStack(@NonNull SavepointStackImpl root, @NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull HandleContext.TransactionCategory category, @NonNull StreamBuilder.SignedTxCustomizer customizer, @NonNull StreamMode streamMode) {
        return new SavepointStackImpl(root, reversingBehavior, category, customizer, streamMode);
    }

    private SavepointStackImpl(@NonNull State state, int maxBuildersBeforeUser, int maxBuildersAfterUser, @NonNull BoundaryStateChangeListener boundaryStateChangeListener, @NonNull ImmediateStateChangeListener immediateStateChangeListener, @NonNull StreamMode streamMode) {
        this.state = Objects.requireNonNull(state);
        this.immediateStateChangeListener = Objects.requireNonNull(immediateStateChangeListener);
        this.boundaryStateChangeListener = Objects.requireNonNull(boundaryStateChangeListener);
        this.builderSink = new BuilderSinkImpl(maxBuildersBeforeUser, maxBuildersAfterUser + 1);
        this.presetIdsAllowed = true;
        this.noncesToSkipPerPresetId = maxBuildersBeforeUser + maxBuildersAfterUser;
        this.setupFirstSavepoint(HandleContext.TransactionCategory.USER);
        this.baseBuilder = this.peek().createBuilder(StreamBuilder.ReversingBehavior.REVERSIBLE, HandleContext.TransactionCategory.USER, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, streamMode, true);
        this.streamMode = Objects.requireNonNull(streamMode);
    }

    private SavepointStackImpl(@NonNull SavepointStackImpl parent, @NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull HandleContext.TransactionCategory category, @NonNull StreamBuilder.SignedTxCustomizer customizer, @NonNull StreamMode streamMode) {
        Objects.requireNonNull(reversingBehavior);
        Objects.requireNonNull(customizer);
        Objects.requireNonNull(category);
        this.streamMode = Objects.requireNonNull(streamMode);
        this.state = Objects.requireNonNull(parent);
        this.builderSink = null;
        this.immediateStateChangeListener = null;
        this.boundaryStateChangeListener = null;
        this.setupFirstSavepoint(category);
        this.baseBuilder = this.peek().createBuilder(reversingBehavior, category, customizer, streamMode, true);
        this.presetIdsAllowed = false;
    }

    public void createSavepoint() {
        this.stack.push(new FollowingSavepoint(new WrappedState(this.peek().state()), this.peek()));
    }

    public void commit() {
        if (this.stack.size() <= 1) {
            throw new IllegalStateException("The savepoint stack is empty");
        }
        this.stack.pop().commit();
    }

    public void rollback() {
        if (this.stack.size() <= 1) {
            throw new IllegalStateException("The savepoint stack is empty");
        }
        this.stack.pop().rollback();
    }

    public int depth() {
        return this.stack.size();
    }

    public void commitFullStack() {
        this.commitTransaction(this.baseBuilder);
    }

    public void commitTransaction(@NonNull StreamBuilder builder) {
        Objects.requireNonNull(builder);
        if (this.streamMode != StreamMode.RECORDS && this.immediateStateChangeListener != null) {
            this.immediateStateChangeListener.reset(builder.logicallyIdenticalValueTest());
        }
        while (!this.stack.isEmpty()) {
            Savepoint savepoint = this.stack.pop();
            if (this.boundaryStateChangeListener != null && this.stack.isEmpty()) {
                this.boundaryStateChangeListener.trackCollectedNodeFees(savepoint.getNodeFeesCollected());
            }
            savepoint.commit();
        }
        if (this.streamMode != StreamMode.RECORDS && this.immediateStateChangeListener != null) {
            builder.stateChanges(this.immediateStateChangeListener.getStateChanges());
        }
        this.setupFirstSavepoint(this.baseBuilder.category());
    }

    public void rollbackFullStack() {
        while (!this.stack.isEmpty()) {
            this.stack.pop().rollback();
        }
        this.setupFirstSavepoint(this.baseBuilder.category());
    }

    public boolean permitsStakingRewards() {
        SavepointStackImpl parent;
        State state;
        return this.builderSink != null || this.baseBuilder.category() == HandleContext.TransactionCategory.SCHEDULED && (state = this.state) instanceof SavepointStackImpl && (parent = (SavepointStackImpl)state).txnCategory() == HandleContext.TransactionCategory.USER;
    }

    @NonNull
    public ReadableStates rootStates(@NonNull String serviceName) {
        return this.state.getReadableStates(serviceName);
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return new ReadonlyStatesWrapper(this.getWritableStates(serviceName));
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("The stack has already been committed");
        }
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> new WritableStatesStack(this, (String)s));
    }

    @NonNull
    public <T extends StreamBuilder> T getBaseBuilder(@NonNull Class<T> recordBuilderClass) {
        Objects.requireNonNull(recordBuilderClass, "recordBuilderClass must not be null");
        return (T)((StreamBuilder)SavepointStackImpl.castBuilder(this.baseBuilder, recordBuilderClass));
    }

    @NonNull
    public <T> T addChildRecordBuilder(@NonNull Class<T> recordBuilderClass, @NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(functionality);
        StreamBuilder result = this.createReversibleChildBuilder().functionality(functionality);
        return SavepointStackImpl.castBuilder(result, recordBuilderClass);
    }

    @NonNull
    public <T> T addRemovableChildRecordBuilder(@NonNull Class<T> recordBuilderClass, @NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(functionality);
        StreamBuilder result = this.createRemovableChildBuilder().functionality(functionality);
        return SavepointStackImpl.castBuilder(result, recordBuilderClass);
    }

    public static <T> T castBuilder(@NonNull StreamBuilder builder, @NonNull Class<T> builderClass) {
        if (!builderClass.isInstance(builder)) {
            throw new IllegalArgumentException("Not a valid record builder class");
        }
        return builderClass.cast(builder);
    }

    public boolean hasMoreSystemRecords() {
        return Objects.requireNonNull(this.builderSink).precedingCapacity() > 0;
    }

    public boolean hasNonBaseStreamBuilder() {
        if (this.builderSink != null && this.builderSink.hasBuilderOtherThan(this.baseBuilder)) {
            return true;
        }
        for (Savepoint savepoint : this.stack) {
            if (!savepoint.hasBuilderOtherThan(this.baseBuilder)) continue;
            return true;
        }
        return false;
    }

    public <T> void forEachNonBaseBuilder(@NonNull Class<T> builderClass, @NonNull Consumer<T> consumer) {
        Objects.requireNonNull(builderClass);
        Objects.requireNonNull(consumer);
        if (this.builderSink != null) {
            this.builderSink.forEachOtherBuilder(consumer, builderClass, this.baseBuilder);
        }
        for (Savepoint savepoint : this.stack) {
            savepoint.forEachOtherBuilder(consumer, builderClass, this.baseBuilder);
        }
    }

    public TransactionID nextPresetTxnId(boolean isLastAllowed) {
        State state = this.state;
        if (state instanceof SavepointStackImpl) {
            SavepointStackImpl parent = (SavepointStackImpl)state;
            return parent.nextPresetTxnId(isLastAllowed);
        }
        if (!this.presetIdsAllowed) {
            throw new HandleException(ResponseCodeEnum.NO_SCHEDULING_ALLOWED_AFTER_SCHEDULED_RECURSION);
        }
        ++this.numPresetIds;
        if (isLastAllowed) {
            this.presetIdsAllowed = false;
        }
        TransactionID baseId = Objects.requireNonNull(this.baseBuilder.transactionID());
        int presetNonce = baseId.nonce() + this.numPresetIds * this.noncesToSkipPerPresetId;
        if (baseId.nonce() < 0 && presetNonce >= 0) {
            throw new HandleException(ResponseCodeEnum.RECURSIVE_SCHEDULING_LIMIT_REACHED);
        }
        return baseId.copyBuilder().nonce(presetNonce).build();
    }

    public HandleContext.TransactionCategory txnCategory() {
        return this.baseBuilder.category();
    }

    public StreamBuilder createRemovableChildBuilder() {
        return this.peek().createBuilder(StreamBuilder.ReversingBehavior.REMOVABLE, HandleContext.TransactionCategory.CHILD, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, this.streamMode, false);
    }

    public StreamBuilder createReversibleChildBuilder() {
        return this.peek().createBuilder(StreamBuilder.ReversingBehavior.REVERSIBLE, HandleContext.TransactionCategory.CHILD, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, this.streamMode, false);
    }

    public StreamBuilder createIrreversiblePrecedingBuilder() {
        return this.peek().createBuilder(StreamBuilder.ReversingBehavior.IRREVERSIBLE, HandleContext.TransactionCategory.PRECEDING, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, this.streamMode, false);
    }

    @NonNull
    public Savepoint peek() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("The stack has already been committed");
        }
        return this.stack.peek();
    }

    public HandleOutput buildHandleOutput(@NonNull Instant consensusTime, @NonNull ExchangeRateSet exchangeRates) {
        LinkedList<BlockStreamBuilder.Output> outputs = this.streamMode != StreamMode.RECORDS ? new LinkedList<BlockStreamBuilder.Output>() : null;
        ArrayList<SingleTransactionRecord> records = this.streamMode != StreamMode.BLOCKS ? new ArrayList<SingleTransactionRecord>() : null;
        ArrayList<RecordSource.IdentifiedReceipt> receipts = this.streamMode != StreamMode.BLOCKS ? new ArrayList<RecordSource.IdentifiedReceipt>() : null;
        Instant lastAssignedConsenusTime = consensusTime;
        List<StreamBuilder> builders = Objects.requireNonNull(this.builderSink).allBuilders();
        TransactionID.Builder idBuilder = null;
        int indexOfParentBuilder = 0;
        int topLevelNonce = 0;
        boolean grouped = false;
        boolean isBatch = false;
        int n = builders.size();
        for (int i = 0; i < n; ++i) {
            StreamBuilder builder = builders.get(i);
            HandleContext.TransactionCategory category = builder.category();
            if (category != HandleContext.TransactionCategory.USER && category != HandleContext.TransactionCategory.NODE) continue;
            indexOfParentBuilder = i;
            topLevelNonce = builder.transactionID().nonce();
            idBuilder = builder.transactionID().copyBuilder();
            grouped = isBatch = builder.functionality() == HederaFunctionality.ATOMIC_BATCH;
            break;
        }
        int nextNonceOffset = 1;
        Instant parentConsensusTime = consensusTime;
        block16: for (int i = 0; i < n; ++i) {
            Instant consensusNow;
            StreamBuilder builder = builders.get(i);
            grouped |= builder.functionality() == HederaFunctionality.HOOK_DISPATCH;
            int nonceOffset = switch (builder.category()) {
                default -> throw new MatchException(null, null);
                case HandleContext.TransactionCategory.USER, HandleContext.TransactionCategory.SCHEDULED, HandleContext.TransactionCategory.NODE, HandleContext.TransactionCategory.BATCH_INNER -> 0;
                case HandleContext.TransactionCategory.PRECEDING, HandleContext.TransactionCategory.CHILD -> nextNonceOffset++;
            };
            TransactionID txnId = builder.transactionID();
            if (txnId == null || TransactionID.DEFAULT.equals((Object)txnId)) {
                if (i > indexOfParentBuilder && isBatch) {
                    if (builder.category() == HandleContext.TransactionCategory.PRECEDING) {
                        for (int j = i + 1; j < n; ++j) {
                            if (builders.get(j).category() != HandleContext.TransactionCategory.BATCH_INNER) continue;
                            idBuilder = builders.get(j).transactionID().copyBuilder();
                            break;
                        }
                    } else if (builder.category() == HandleContext.TransactionCategory.CHILD) {
                        for (int j = i - 1; j > indexOfParentBuilder; --j) {
                            if (builders.get(j).category() != HandleContext.TransactionCategory.BATCH_INNER) continue;
                            idBuilder = builders.get(j).transactionID().copyBuilder();
                            break;
                        }
                    }
                }
                builder.transactionID(Objects.requireNonNull(idBuilder).nonce(topLevelNonce + nonceOffset).build()).syncBodyIdFromRecordId();
            }
            lastAssignedConsenusTime = consensusNow = consensusTime.plusNanos((long)i - (long)indexOfParentBuilder);
            builder.consensusTimestamp(consensusNow);
            if (i > indexOfParentBuilder) {
                switch (builder.category()) {
                    case SCHEDULED: {
                        builder.exchangeRate(exchangeRates).triggeringParentConsensus(consensusTime);
                        break;
                    }
                    case BATCH_INNER: {
                        builder.parentConsensus(consensusTime).exchangeRate(null);
                        parentConsensusTime = consensusNow;
                        break;
                    }
                    case PRECEDING: {
                        builder.parentConsensus(consensusTime).exchangeRate(null);
                        break;
                    }
                    case CHILD: {
                        builder.parentConsensus(parentConsensusTime).exchangeRate(null);
                    }
                }
            }
            switch (this.streamMode) {
                case RECORDS: {
                    SingleTransactionRecord nextRecord = ((RecordStreamBuilder)builder).build();
                    records.add(nextRecord);
                    receipts.add(new RecordSource.IdentifiedReceipt(nextRecord.transactionRecord().transactionIDOrThrow(), nextRecord.transactionRecord().receiptOrThrow()));
                    continue block16;
                }
                case BLOCKS: {
                    List groupStateChanges = grouped ? this.baseBuilder.getStateChanges() : null;
                    ((List)Objects.requireNonNull(outputs)).add(((BlockStreamBuilder)builder).build(builder == this.baseBuilder, groupStateChanges));
                    continue block16;
                }
                case BOTH: {
                    PairedStreamBuilder pairedBuilder = (PairedStreamBuilder)builder;
                    records.add(pairedBuilder.recordStreamBuilder().build());
                    List groupStateChanges = grouped ? this.baseBuilder.getStateChanges() : null;
                    ((List)Objects.requireNonNull(outputs)).add(pairedBuilder.blockStreamBuilder().build(builder == this.baseBuilder, groupStateChanges));
                }
            }
        }
        BlockRecordSource blockRecordSource = null;
        if (this.streamMode != StreamMode.RECORDS) {
            blockRecordSource = new BlockRecordSource(outputs);
        }
        LegacyListRecordSource recordSource = this.streamMode != StreamMode.BLOCKS ? new LegacyListRecordSource(records, receipts) : null;
        return new HandleOutput(blockRecordSource, recordSource, lastAssignedConsenusTime);
    }

    private void setupFirstSavepoint(@NonNull HandleContext.TransactionCategory category) {
        State state = this.state;
        if (state instanceof SavepointStackImpl) {
            SavepointStackImpl parent = (SavepointStackImpl)state;
            this.stack.push(new FirstChildSavepoint(new WrappedState(this.state), (BuilderSink)parent.peek(), category));
        } else {
            this.stack.push(new FirstRootSavepoint(new WrappedState(this.state), Objects.requireNonNull(this.builderSink)));
        }
    }

    public void setHash(Hash hash) {
        this.state.setHash(hash);
    }

    public boolean isStartUpMode() {
        return this.state.isStartUpMode();
    }
}

