/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.connectivity;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.NetworkPeerIdentifier;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.SocketConfig;
import com.swirlds.platform.network.SocketConnection;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableConsumer;
import org.hiero.consensus.model.node.NodeId;

public class InboundConnectionHandler {
    private static final Logger logger = LogManager.getLogger(InboundConnectionHandler.class);
    private final ConnectionTracker connectionTracker;
    private final NodeId selfId;
    private final InterruptableConsumer<Connection> newConnectionConsumer;
    private final SocketConfig socketConfig;
    private final RateLimitedLogger socketExceptionLogger;
    private final PlatformContext platformContext;
    private final NetworkPeerIdentifier networkPeerIdentifier;
    private final Time time;

    public InboundConnectionHandler(@NonNull PlatformContext platformContext, @NonNull ConnectionTracker connectionTracker, @NonNull List<PeerInfo> peers, @NonNull NodeId selfId, @NonNull InterruptableConsumer<Connection> newConnectionConsumer, @NonNull Time time) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.connectionTracker = Objects.requireNonNull(connectionTracker);
        this.selfId = Objects.requireNonNull(selfId);
        this.newConnectionConsumer = Objects.requireNonNull(newConnectionConsumer);
        this.time = Objects.requireNonNull(time);
        this.socketExceptionLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.socketConfig = (SocketConfig)platformContext.getConfiguration().getConfigData(SocketConfig.class);
        this.networkPeerIdentifier = new NetworkPeerIdentifier(platformContext, Objects.requireNonNull(peers));
    }

    public void handle(@NonNull Socket clientSocket) {
        long acceptTime = this.time.currentTimeMillis();
        Objects.requireNonNull(clientSocket);
        String remoteIp = "unknown";
        try {
            remoteIp = clientSocket.getInetAddress().toString();
            clientSocket.setTcpNoDelay(this.socketConfig.tcpNoDelay());
            clientSocket.setSoTimeout(this.socketConfig.timeoutSyncClientSocket());
            SSLSocket sslSocket = (SSLSocket)clientSocket;
            PeerInfo connectedPeer = this.networkPeerIdentifier.identifyTlsPeer(sslSocket.getSession().getPeerCertificates());
            if (connectedPeer == null) {
                clientSocket.close();
                return;
            }
            NodeId otherId = connectedPeer.nodeId();
            SyncInputStream sis = SyncInputStream.createSyncInputStream(this.platformContext, clientSocket.getInputStream(), this.socketConfig.bufferSize());
            SyncOutputStream sos = SyncOutputStream.createSyncOutputStream(this.platformContext, clientSocket.getOutputStream(), this.socketConfig.bufferSize());
            SocketConnection sc = SocketConnection.create(this.selfId, otherId, this.connectionTracker, false, clientSocket, sis, sos, this.platformContext.getConfiguration());
            this.newConnectionConsumer.accept((Object)sc);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String formattedException = NetworkUtils.formatException(e);
            logger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "Inbound connection from {} to {} was interrupted: {}", (Object)remoteIp, (Object)this.selfId, (Object)formattedException);
            NetworkUtils.close(clientSocket);
        }
        catch (IOException e) {
            String formattedException = NetworkUtils.formatException(e);
            this.socketExceptionLogger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "Inbound connection from {} to {} had IOException: {}", new Object[]{remoteIp, this.selfId, formattedException});
            NetworkUtils.close(clientSocket);
        }
        catch (RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Inbound connection error, remote IP: {}\nTime from accept to exception: {} ms", (Object)(clientSocket.getInetAddress() != null ? clientSocket.getInetAddress().toString() : "null IP"), acceptTime == 0L ? "N/A" : Long.valueOf(System.currentTimeMillis() - acceptTime), (Object)e);
            NetworkUtils.close(clientSocket);
        }
    }

    public InboundConnectionHandler withNewPeers(@NonNull List<PeerInfo> newPeers) {
        return new InboundConnectionHandler(this.platformContext, this.connectionTracker, newPeers, this.selfId, this.newConnectionConsumer, this.time);
    }
}

