/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.test.fixtures.hashgraph;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class EventWindowBuilder {
    private Long latestConsensusRound;
    private Long newEventBirthRound;
    private Long ancientThreshold;
    private Long expiredThreshold;

    private EventWindowBuilder() {
    }

    @NonNull
    public static EventWindowBuilder builder() {
        return new EventWindowBuilder();
    }

    @NonNull
    public EventWindowBuilder setLatestConsensusRound(long latestConsensusRound) {
        this.latestConsensusRound = latestConsensusRound;
        return this;
    }

    @NonNull
    public EventWindowBuilder setNewEventBirthRound(long newEventBirthRound) {
        this.newEventBirthRound = newEventBirthRound;
        return this;
    }

    @NonNull
    public EventWindowBuilder setAncientThreshold(long ancientThreshold) {
        this.ancientThreshold = ancientThreshold;
        return this;
    }

    @NonNull
    public EventWindowBuilder setAncientThresholdOrGenesis(long ancientThreshold) {
        this.ancientThreshold = Math.max(1L, ancientThreshold);
        return this;
    }

    @NonNull
    public EventWindowBuilder setExpiredThreshold(long expiredThreshold) {
        this.expiredThreshold = expiredThreshold;
        return this;
    }

    @NonNull
    public EventWindowBuilder setExpiredThresholdOrGenesis(long expiredThreshold) {
        this.expiredThreshold = Math.max(1L, expiredThreshold);
        return this;
    }

    @NonNull
    public EventWindow build() {
        return new EventWindow(this.latestConsensusRound == null ? 1L : this.latestConsensusRound, this.newEventBirthRound == null ? 1L : this.newEventBirthRound, this.ancientThreshold == null ? 1L : this.ancientThreshold, this.expiredThreshold == null ? 1L : this.expiredThreshold);
    }
}

