/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;

public final class EqualsVerifier {
    private static final Random random = new Random();

    private EqualsVerifier() {
    }

    public static Hash randomHash(RandomGenerator r) {
        int SIZE = 48;
        byte[] value = new byte[48];
        r.nextBytes(value);
        return new Hash(value, DigestType.SHA_384);
    }

    public static <R> List<R> generateObjects(Function<Random, R> supplier, long[] seeds) {
        ArrayList<R> objects = new ArrayList<R>();
        for (long seed : seeds) {
            random.setSeed(seed);
            objects.add(supplier.apply(random));
        }
        return objects;
    }

    public static <R> boolean verifyEqualsHashCode(R original, R copy, R other) {
        if (original.equals(null)) {
            return false;
        }
        if (!original.equals(original)) {
            return false;
        }
        if (!original.equals(copy)) {
            return false;
        }
        if (!copy.equals(original)) {
            return false;
        }
        if (original.equals(other)) {
            return false;
        }
        if (copy.equals(other)) {
            return false;
        }
        if (!original.equals(copy)) {
            return false;
        }
        if (original.hashCode() != copy.hashCode()) {
            return false;
        }
        return original.hashCode() != other.hashCode();
    }

    public static <R> boolean verify(Function<Random, R> supplier) {
        List<R> list = EqualsVerifier.generateObjects(supplier, new long[]{1L, 1L, 2L});
        return EqualsVerifier.verifyEqualsHashCode(list.get(0), list.get(1), list.get(2));
    }

    public static <R extends Comparable<R>> boolean verifyCompareTo(R original, R copy, R other) {
        if (original.compareTo(original) != 0) {
            return false;
        }
        if (original.compareTo(copy) != 0) {
            return false;
        }
        if (copy.compareTo(original) != 0) {
            return false;
        }
        return original.compareTo(other) * other.compareTo(original) < 0;
    }
}

