/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.benchmark;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.test.fixtures.benchmark.Benchmark;
import com.swirlds.common.test.fixtures.benchmark.BenchmarkMetadata;
import com.swirlds.common.test.fixtures.benchmark.BenchmarkOperation;
import java.time.Duration;
import java.util.List;

public class BenchmarkConfiguration<M extends MerkleNode, B extends BenchmarkMetadata> {
    private M initialState;
    private B initialBenchmarkState;
    private List<BenchmarkOperation<M, B>> mutableStateOperations;
    private List<BenchmarkOperation<M, B>> immutableStateOperations;
    private int immutableThreadCount = 5;
    private Duration roundPeriod = Duration.ofMillis(100L);
    private int statesInMemory = 10;
    private Duration spinUpTime = Duration.ofSeconds(5L);
    private Duration testDuration = Duration.ofMinutes(1L);

    public Benchmark<M, B> build() {
        Benchmark<M, B> benchmark = new Benchmark<M, B>(this.initialState, this.initialBenchmarkState, this.mutableStateOperations, this.immutableStateOperations, this.immutableThreadCount, this.roundPeriod, this.statesInMemory, this.spinUpTime, this.testDuration);
        this.initialState = null;
        this.initialBenchmarkState = null;
        return benchmark;
    }

    public MerkleNode getInitialState() {
        return this.initialState;
    }

    public BenchmarkConfiguration<M, B> setInitialState(M initialState) {
        this.initialState = initialState;
        return this;
    }

    public B getInitialBenchmarkState() {
        return this.initialBenchmarkState;
    }

    public BenchmarkConfiguration<M, B> setBenchmarkMetadata(B initialBenchmarkState) {
        this.initialBenchmarkState = initialBenchmarkState;
        return this;
    }

    public List<BenchmarkOperation<M, B>> getMutableStateOperations() {
        return this.mutableStateOperations;
    }

    public BenchmarkConfiguration<M, B> setMutableStateOperations(List<BenchmarkOperation<M, B>> mutableStateOperations) {
        this.mutableStateOperations = mutableStateOperations;
        return this;
    }

    public List<BenchmarkOperation<M, B>> getImmutableStateOperations() {
        return this.immutableStateOperations;
    }

    public BenchmarkConfiguration<M, B> setImmutableStateOperations(List<BenchmarkOperation<M, B>> immutableStateOperations) {
        this.immutableStateOperations = immutableStateOperations;
        return this;
    }

    public int getImmutableThreadCount() {
        return this.immutableThreadCount;
    }

    public BenchmarkConfiguration<M, B> setImmutableThreadCount(int immutableThreadCount) {
        this.immutableThreadCount = immutableThreadCount;
        return this;
    }

    public Duration getRoundPeriod() {
        return this.roundPeriod;
    }

    public BenchmarkConfiguration<M, B> setRoundPeriod(Duration roundPeriod) {
        this.roundPeriod = roundPeriod;
        return this;
    }

    public int getStatesInMemory() {
        return this.statesInMemory;
    }

    public BenchmarkConfiguration<M, B> setStatesInMemory(int statesInMemory) {
        this.statesInMemory = statesInMemory;
        return this;
    }

    public Duration getSpinUpTime() {
        return this.spinUpTime;
    }

    public BenchmarkConfiguration<M, B> setSpinUpTime(Duration spinUpTime) {
        this.spinUpTime = spinUpTime;
        return this;
    }

    public Duration getTestDuration() {
        return this.testDuration;
    }

    public BenchmarkConfiguration<M, B> setTestDuration(Duration testDuration) {
        this.testDuration = testDuration;
        return this;
    }
}

