/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.node.contract.codec.EvmTransactionResultJsonCodec;
import com.hedera.hapi.node.contract.codec.EvmTransactionResultProtoCodec;
import com.hedera.hapi.node.contract.schema.EvmTransactionResultSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class EvmTransactionResult {
    public static final Codec<EvmTransactionResult> PROTOBUF = new EvmTransactionResultProtoCodec();
    public static final JsonCodec<EvmTransactionResult> JSON = new EvmTransactionResultJsonCodec();
    public static final EvmTransactionResult DEFAULT = EvmTransactionResult.newBuilder().build();
    @Nullable
    private final AccountID senderId;
    @Nullable
    private final ContractID contractId;
    @NonNull
    private final Bytes resultData;
    @NonNull
    private final String errorMessage;
    private final long gasUsed;
    @Nullable
    private final InternalCallContext internalCallContext;
    @Nullable
    private final HookId executedHookId;
    @NonNull
    private final List<ContractNonceInfo> contractNonces;
    @Nullable
    private final Long signerNonce;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public EvmTransactionResult(AccountID senderId, ContractID contractId, Bytes resultData, String errorMessage, long gasUsed, InternalCallContext internalCallContext, HookId executedHookId, List<ContractNonceInfo> contractNonces, Long signerNonce) {
        this.$unknownFields = null;
        this.senderId = senderId;
        this.contractId = contractId;
        this.resultData = resultData != null ? resultData : Bytes.EMPTY;
        this.errorMessage = errorMessage != null ? errorMessage : "";
        this.gasUsed = gasUsed;
        this.internalCallContext = internalCallContext;
        this.executedHookId = executedHookId;
        this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
        this.signerNonce = signerNonce;
    }

    public EvmTransactionResult(AccountID senderId, ContractID contractId, Bytes resultData, String errorMessage, long gasUsed, InternalCallContext internalCallContext, HookId executedHookId, List<ContractNonceInfo> contractNonces, Long signerNonce, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.senderId = senderId;
        this.contractId = contractId;
        this.resultData = resultData != null ? resultData : Bytes.EMPTY;
        this.errorMessage = errorMessage != null ? errorMessage : "";
        this.gasUsed = gasUsed;
        this.internalCallContext = internalCallContext;
        this.executedHookId = executedHookId;
        this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
        this.signerNonce = signerNonce;
    }

    public AccountID senderId() {
        return this.senderId;
    }

    public ContractID contractId() {
        return this.contractId;
    }

    public Bytes resultData() {
        return this.resultData;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public long gasUsed() {
        return this.gasUsed;
    }

    public InternalCallContext internalCallContext() {
        return this.internalCallContext;
    }

    public HookId executedHookId() {
        return this.executedHookId;
    }

    public List<ContractNonceInfo> contractNonces() {
        return this.contractNonces;
    }

    public Long signerNonce() {
        return this.signerNonce;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EvmTransactionResultSchema.SENDER_ID, (Object)this.senderId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EvmTransactionResultSchema.CONTRACT_ID, (Object)this.contractId, ContractID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)EvmTransactionResultSchema.RESULT_DATA, (RandomAccessData)this.resultData, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)EvmTransactionResultSchema.ERROR_MESSAGE, (String)this.errorMessage, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)EvmTransactionResultSchema.GAS_USED, (long)this.gasUsed, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EvmTransactionResultSchema.INTERNAL_CALL_CONTEXT, (Object)this.internalCallContext, InternalCallContext.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EvmTransactionResultSchema.EXECUTED_HOOK_ID, (Object)this.executedHookId, HookId.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)EvmTransactionResultSchema.CONTRACT_NONCES, this.contractNonces, ContractNonceInfo.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalLong((FieldDefinition)EvmTransactionResultSchema.SIGNER_NONCE, (Long)this.signerNonce);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<ContractNonceInfo> list$contractNonces;
            int result = 1;
            if (this.senderId != null && !this.senderId.equals(EvmTransactionResult.DEFAULT.senderId)) {
                result = 31 * result + this.senderId.hashCode();
            }
            if (this.contractId != null && !this.contractId.equals(EvmTransactionResult.DEFAULT.contractId)) {
                result = 31 * result + this.contractId.hashCode();
            }
            if (this.resultData != null && !this.resultData.equals((Object)EvmTransactionResult.DEFAULT.resultData)) {
                result = 31 * result + this.resultData.hashCode();
            }
            if (this.errorMessage != null && !this.errorMessage.equals(EvmTransactionResult.DEFAULT.errorMessage)) {
                result = 31 * result + this.errorMessage.hashCode();
            }
            if (this.gasUsed != EvmTransactionResult.DEFAULT.gasUsed) {
                result = 31 * result + Long.hashCode(this.gasUsed);
            }
            if (this.internalCallContext != null && !this.internalCallContext.equals(EvmTransactionResult.DEFAULT.internalCallContext)) {
                result = 31 * result + this.internalCallContext.hashCode();
            }
            if (this.executedHookId != null && !this.executedHookId.equals(EvmTransactionResult.DEFAULT.executedHookId)) {
                result = 31 * result + this.executedHookId.hashCode();
            }
            if ((list$contractNonces = this.contractNonces) != null) {
                for (ContractNonceInfo o : list$contractNonces) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.signerNonce != null && !this.signerNonce.equals(EvmTransactionResult.DEFAULT.signerNonce)) {
                result = 31 * result + Long.hashCode(this.signerNonce);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        EvmTransactionResult thatObj = (EvmTransactionResult)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.senderId == null && thatObj.senderId != null) {
            return false;
        }
        if (this.senderId != null && !this.senderId.equals(thatObj.senderId)) {
            return false;
        }
        if (this.contractId == null && thatObj.contractId != null) {
            return false;
        }
        if (this.contractId != null && !this.contractId.equals(thatObj.contractId)) {
            return false;
        }
        if (this.resultData == null && thatObj.resultData != null) {
            return false;
        }
        if (this.resultData != null && !this.resultData.equals((Object)thatObj.resultData)) {
            return false;
        }
        if (this.errorMessage == null && thatObj.errorMessage != null) {
            return false;
        }
        if (this.errorMessage != null && !this.errorMessage.equals(thatObj.errorMessage)) {
            return false;
        }
        if (this.gasUsed != thatObj.gasUsed) {
            return false;
        }
        if (this.internalCallContext == null && thatObj.internalCallContext != null) {
            return false;
        }
        if (this.internalCallContext != null && !this.internalCallContext.equals(thatObj.internalCallContext)) {
            return false;
        }
        if (this.executedHookId == null && thatObj.executedHookId != null) {
            return false;
        }
        if (this.executedHookId != null && !this.executedHookId.equals(thatObj.executedHookId)) {
            return false;
        }
        if (this.contractNonces == null && thatObj.contractNonces != null) {
            return false;
        }
        if (this.contractNonces != null && !this.contractNonces.equals(thatObj.contractNonces)) {
            return false;
        }
        if (this.signerNonce == null && thatObj.signerNonce != null) {
            return false;
        }
        if (this.signerNonce != null && !this.signerNonce.equals(thatObj.signerNonce)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "EvmTransactionResult[senderId=" + String.valueOf(this.senderId) + ", contractId=" + String.valueOf(this.contractId) + ", resultData=" + String.valueOf(this.resultData) + ", errorMessage=" + this.errorMessage + ", gasUsed=" + this.gasUsed + ", internalCallContext=" + String.valueOf(this.internalCallContext) + ", executedHookId=" + String.valueOf(this.executedHookId) + ", contractNonces=" + String.valueOf(this.contractNonces) + ", signerNonce=" + this.signerNonce + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public boolean hasContractId() {
        return this.contractId != null;
    }

    public ContractID contractIdOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractId() ? this.contractId : defaultValue;
    }

    @NonNull
    public ContractID contractIdOrThrow() {
        return Objects.requireNonNull(this.contractId, "Field contractId is null");
    }

    public void ifContractId(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractId()) {
            ifPresent.accept(this.contractId);
        }
    }

    public boolean hasInternalCallContext() {
        return this.internalCallContext != null;
    }

    public InternalCallContext internalCallContextOrElse(@NonNull InternalCallContext defaultValue) {
        return this.hasInternalCallContext() ? this.internalCallContext : defaultValue;
    }

    @NonNull
    public InternalCallContext internalCallContextOrThrow() {
        return Objects.requireNonNull(this.internalCallContext, "Field internalCallContext is null");
    }

    public void ifInternalCallContext(@NonNull Consumer<InternalCallContext> ifPresent) {
        if (this.hasInternalCallContext()) {
            ifPresent.accept(this.internalCallContext);
        }
    }

    public boolean hasExecutedHookId() {
        return this.executedHookId != null;
    }

    public HookId executedHookIdOrElse(@NonNull HookId defaultValue) {
        return this.hasExecutedHookId() ? this.executedHookId : defaultValue;
    }

    @NonNull
    public HookId executedHookIdOrThrow() {
        return Objects.requireNonNull(this.executedHookId, "Field executedHookId is null");
    }

    public void ifExecutedHookId(@NonNull Consumer<HookId> ifPresent) {
        if (this.hasExecutedHookId()) {
            ifPresent.accept(this.executedHookId);
        }
    }

    public boolean hasSignerNonce() {
        return this.signerNonce != null;
    }

    public Long signerNonceOrElse(@NonNull Long defaultValue) {
        return this.hasSignerNonce() ? this.signerNonce : defaultValue;
    }

    @NonNull
    public Long signerNonceOrThrow() {
        return Objects.requireNonNull(this.signerNonce, "Field signerNonce is null");
    }

    public void ifSignerNonce(@NonNull Consumer<Long> ifPresent) {
        if (this.hasSignerNonce()) {
            ifPresent.accept(this.signerNonce);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.senderId, this.contractId, this.resultData, this.errorMessage, this.gasUsed, this.internalCallContext, this.executedHookId, this.contractNonces, this.signerNonce, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID senderId = null;
        @Nullable
        private ContractID contractId = null;
        @NonNull
        private Bytes resultData = Bytes.EMPTY;
        @NonNull
        private String errorMessage = "";
        private long gasUsed = 0L;
        @Nullable
        private InternalCallContext internalCallContext = null;
        @Nullable
        private HookId executedHookId = null;
        @NonNull
        private List<ContractNonceInfo> contractNonces = Collections.emptyList();
        @Nullable
        private Long signerNonce = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID senderId, ContractID contractId, Bytes resultData, String errorMessage, long gasUsed, InternalCallContext internalCallContext, HookId executedHookId, List<ContractNonceInfo> contractNonces, Long signerNonce) {
            this.$unknownFields = null;
            this.senderId = senderId;
            this.contractId = contractId;
            this.resultData = resultData != null ? resultData : Bytes.EMPTY;
            this.errorMessage = errorMessage != null ? errorMessage : "";
            this.gasUsed = gasUsed;
            this.internalCallContext = internalCallContext;
            this.executedHookId = executedHookId;
            this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
            this.signerNonce = signerNonce;
        }

        public Builder(AccountID senderId, ContractID contractId, Bytes resultData, String errorMessage, long gasUsed, InternalCallContext internalCallContext, HookId executedHookId, List<ContractNonceInfo> contractNonces, Long signerNonce, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.senderId = senderId;
            this.contractId = contractId;
            this.resultData = resultData != null ? resultData : Bytes.EMPTY;
            this.errorMessage = errorMessage != null ? errorMessage : "";
            this.gasUsed = gasUsed;
            this.internalCallContext = internalCallContext;
            this.executedHookId = executedHookId;
            this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
            this.signerNonce = signerNonce;
        }

        public EvmTransactionResult build() {
            return new EvmTransactionResult(this.senderId, this.contractId, this.resultData, this.errorMessage, this.gasUsed, this.internalCallContext, this.executedHookId, this.contractNonces, this.signerNonce);
        }

        public Builder senderId(@Nullable AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }

        public Builder contractId(@Nullable ContractID contractId) {
            this.contractId = contractId;
            return this;
        }

        public Builder contractId(ContractID.Builder builder) {
            this.contractId = builder.build();
            return this;
        }

        public Builder resultData(@NonNull Bytes resultData) {
            this.resultData = resultData != null ? resultData : Bytes.EMPTY;
            return this;
        }

        public Builder errorMessage(@NonNull String errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage : "";
            return this;
        }

        public Builder gasUsed(long gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public Builder internalCallContext(@Nullable InternalCallContext internalCallContext) {
            this.internalCallContext = internalCallContext;
            return this;
        }

        public Builder internalCallContext(InternalCallContext.Builder builder) {
            this.internalCallContext = builder.build();
            return this;
        }

        public Builder executedHookId(@Nullable HookId executedHookId) {
            this.executedHookId = executedHookId;
            return this;
        }

        public Builder executedHookId(HookId.Builder builder) {
            this.executedHookId = builder.build();
            return this;
        }

        public Builder contractNonces(@NonNull List<ContractNonceInfo> contractNonces) {
            this.contractNonces = contractNonces != null ? contractNonces : Collections.emptyList();
            return this;
        }

        public Builder contractNonces(ContractNonceInfo ... values) {
            this.contractNonces = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder signerNonce(@Nullable Long signerNonce) {
            this.signerNonce = signerNonce;
            return this;
        }
    }
}

