/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.transformers.AdvancedTransformation;
import com.swirlds.component.framework.transformers.WireFilter;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.event.validation.InternalEventValidator;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.state.notifications.StateHashedNotification;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.SignedStateReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityToStateReserver;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.event.creator.EventCreationConfig;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class PlatformWiring {
    public static void wire(@NonNull PlatformContext platformContext, @NonNull ExecutionLayer execution, @NonNull PlatformComponents components, @NonNull ApplicationCallbacks callbacks) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(execution);
        Objects.requireNonNull(components);
        InputWire hasherInputWire = components.eventHasherWiring().getInputWire(EventHasher::hashEvent, "unhashed event");
        components.gossipWiring().getEventOutput().solderTo(hasherInputWire);
        components.gossipWiring().getSyncLagOutput().solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::reportSyncRoundLag));
        components.eventHasherWiring().getOutputWire().solderTo(components.internalEventValidatorWiring().getInputWire(InternalEventValidator::validateEvent));
        components.internalEventValidatorWiring().getOutputWire().solderTo(components.eventDeduplicatorWiring().getInputWire(EventDeduplicator::handleEvent));
        components.eventDeduplicatorWiring().getOutputWire().solderTo(components.eventSignatureValidatorWiring().getInputWire(EventSignatureValidator::validateSignature));
        components.eventSignatureValidatorWiring().getOutputWire().solderTo(components.orphanBufferWiring().getInputWire(OrphanBuffer::handleEvent));
        OutputWire splitOrphanBufferOutput = components.orphanBufferWiring().getSplitOutput();
        splitOrphanBufferOutput.solderTo(components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::writeEvent));
        components.pcesInlineWriterWiring().getOutputWire().solderTo(components.consensusEngineWiring().componentWiring().getInputWire(ConsensusEngine::addEvent));
        components.pcesInlineWriterWiring().getOutputWire().solderTo(components.gossipWiring().getEventInput(), SolderType.INJECT);
        components.pcesInlineWriterWiring().getOutputWire().solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::registerEvent));
        components.model().getHealthMonitorWire().solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::reportUnhealthyDuration));
        components.model().getHealthMonitorWire().solderTo(components.gossipWiring().getSystemHealthInput());
        components.model().getHealthMonitorWire().solderTo("executionHealthInput", "healthyDuration", execution::reportUnhealthyDuration);
        splitOrphanBufferOutput.solderTo(components.branchDetectorWiring().getInputWire(BranchDetector::checkForBranches));
        components.branchDetectorWiring().getOutputWire().solderTo(components.branchReporterWiring().getInputWire(BranchReporter::reportBranch));
        double eventCreationHeartbeatFrequency = ((EventCreationConfig)platformContext.getConfiguration().getConfigData(EventCreationConfig.class)).creationAttemptRate();
        components.model().buildHeartbeatWire(eventCreationHeartbeatFrequency).solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::maybeCreateEvent), SolderType.OFFER);
        components.model().buildHeartbeatWire(((PlatformStatusConfig)platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class)).statusStateMachineHeartbeatPeriod()).solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::heartbeat), SolderType.OFFER);
        components.eventCreationManagerWiring().getOutputWire().solderTo(components.internalEventValidatorWiring().getInputWire(InternalEventValidator::validateEvent), SolderType.INJECT);
        if (callbacks.staleEventConsumer() != null) {
            OutputWire staleEvent = components.consensusEngineWiring().getOutputWire().buildTransformer("staleEvents", "consensusEngineOutput", ConsensusEngineOutput::staleEvents).buildSplitter("staleEventsSplitter", "stale events");
            staleEvent.solderTo("staleEventCallback", "stale events", callbacks.staleEventConsumer());
        }
        OutputWire consEngineAddedEvents = components.consensusEngineWiring().getOutputWire().buildTransformer("PreConsensusEvents", "consensusEngineOutput", ConsensusEngineOutput::preConsensusEvents).buildSplitter("PreConsensusEventsSplitter", "preConsensusEvents");
        consEngineAddedEvents.solderTo(components.applicationTransactionPrehandlerWiring().getInputWire(TransactionPrehandler::prehandleApplicationTransactions));
        components.applicationTransactionPrehandlerWiring().getOutputWire().solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::handlePreconsensusSignatures));
        OutputWire splitReservedSignedStateWire = components.stateSignatureCollectorWiring().getOutputWire().buildSplitter("reservedStateSplitter", "reserved state lists");
        OutputWire allReservedSignedStatesWire = splitReservedSignedStateWire.buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("allStatesReserver"));
        WireFilter saveToDiskFilter = new WireFilter(components.model(), "saveToDiskFilter", "states", state -> {
            if (state.get().isStateToSave()) {
                return true;
            }
            state.close();
            return false;
        });
        allReservedSignedStatesWire.solderTo(saveToDiskFilter.getInputWire());
        saveToDiskFilter.getOutputWire().solderTo(components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::saveStateTask));
        OutputWire completeReservedSignedStatesWire = allReservedSignedStatesWire.buildFilter("completeStateFilter", "states", rs -> {
            if (rs.get().isComplete()) {
                return true;
            }
            rs.close();
            return false;
        }).buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("completeStatesReserver"));
        completeReservedSignedStatesWire.solderTo(components.latestCompleteStateNexusWiring().getInputWire(LatestCompleteStateNexus::setStateIfNewer));
        PlatformWiring.solderEventWindow(components);
        components.pcesReplayerWiring().eventOutput().solderTo(hasherInputWire);
        OutputWire consensusRoundOutputWire = components.consensusEngineWiring().consensusRoundsOutputWire().buildSplitter("ConsensusRoundsSplitter", "consensus rounds");
        components.pcesReplayerWiring().doneStreamingPcesOutputWire().solderTo(components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::beginStreamingNewEvents));
        consensusRoundOutputWire.solderTo(components.transactionHandlerWiring().getInputWire(TransactionHandler::handleConsensusRound));
        consensusRoundOutputWire.solderTo(components.eventWindowManagerWiring().getInputWire(EventWindowManager::extractEventWindow));
        consensusRoundOutputWire.buildTransformer("RoundsToCesEvents", "consensus rounds", ConsensusRound::getStreamedEvents).solderTo(components.consensusEventStreamWiring().getInputWire(ConsensusEventStream::addEvents));
        consensusRoundOutputWire.solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::consensusRound));
        OutputWire transactionHandlerSysTxnsOutputWire = components.transactionHandlerWiring().getOutputWire().buildTransformer("getSystemTransactions", "transaction handler result", TransactionHandlerResult::systemTransactions);
        transactionHandlerSysTxnsOutputWire.solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::handlePostconsensusSignatures));
        transactionHandlerSysTxnsOutputWire.solderTo(components.issDetectorWiring().getInputWire(IssDetector::handleStateSignatureTransactions));
        OutputWire transactionHandlerStateWithComplexityOutput = components.transactionHandlerWiring().getOutputWire().buildFilter("notNullStateFilter", "transaction handler result", thr -> thr.stateWithHashComplexity() != null).buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityReserver("postHandler_stateWithHashComplexityReserver"));
        transactionHandlerStateWithComplexityOutput.solderTo(components.savedStateControllerWiring().getInputWire(SavedStateController::markSavedState));
        OutputWire transactionHandlerStateOnlyOutput = transactionHandlerStateWithComplexityOutput.buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityToStateReserver("postHandler_stateWithHashComplexityToStateReserver"));
        transactionHandlerStateOnlyOutput.solderTo(components.latestImmutableStateNexusWiring().getInputWire(SignedStateNexus::setState));
        transactionHandlerStateOnlyOutput.solderTo(components.stateGarbageCollectorWiring().getInputWire(StateGarbageCollector::registerState));
        components.savedStateControllerWiring().getOutputWire().solderTo(components.stateHasherWiring().getInputWire(StateHasher::hashState));
        PlatformSchedulersConfig config = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        components.model().buildHeartbeatWire(config.stateGarbageCollectorHeartbeatPeriod()).solderTo(components.stateGarbageCollectorWiring().getInputWire(StateGarbageCollector::heartbeat), SolderType.OFFER);
        components.model().buildHeartbeatWire(config.signedStateSentinelHeartbeatPeriod()).solderTo(components.signedStateSentinelWiring().getInputWire(SignedStateSentinel::checkSignedStates), SolderType.OFFER);
        OutputWire hashedStateOutputWire = components.stateHasherWiring().getOutputWire().buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("postHasher_stateReserver"));
        hashedStateOutputWire.solderTo(components.hashLoggerWiring().getInputWire(HashLogger::logHashes));
        hashedStateOutputWire.solderTo(components.stateSignerWiring().getInputWire(StateSigner::signState));
        hashedStateOutputWire.solderTo(components.issDetectorWiring().getInputWire(IssDetector::handleState));
        hashedStateOutputWire.buildTransformer("postHasher_notifier", "hashed states", StateHashedNotification::from).solderTo(components.notifierWiring().getInputWire(AppNotifier::sendStateHashedNotification));
        components.stateSignerWiring().getOutputWire().solderTo("ExecutionSignatureSubmission", "state signatures", execution::submitStateSignature);
        hashedStateOutputWire.solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState));
        components.stateSnapshotManagerWiring().getTransformedOutput(StateSnapshotManager::extractOldestMinimumBirthRoundOnDisk).solderTo(components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::setMinimumAncientIdentifierToStore), SolderType.INJECT);
        components.stateSnapshotManagerWiring().getOutputWire().solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::stateWrittenToDisk));
        components.runningEventHashOverrideWiring().runningHashUpdateOutput().solderTo(components.transactionHandlerWiring().getInputWire(TransactionHandler::updateLegacyRunningEventHash));
        components.runningEventHashOverrideWiring().runningHashUpdateOutput().solderTo(components.consensusEventStreamWiring().getInputWire(ConsensusEventStream::legacyHashOverride));
        OutputWire splitIssDetectorOutput = components.issDetectorWiring().getSplitOutput();
        splitIssDetectorOutput.solderTo(components.issHandlerWiring().getInputWire(IssHandler::issObserved));
        components.issDetectorWiring().getOutputWire().solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::issNotification));
        completeReservedSignedStatesWire.solderTo(components.latestCompleteStateNotifierWiring().getInputWire(LatestCompleteStateNotifier::latestCompleteStateHandler));
        components.platformMonitorWiring().getOutputWire().solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::updatePlatformStatus));
        components.platformMonitorWiring().getOutputWire().solderTo(components.consensusEngineWiring().getInputWire(ConsensusEngine::updatePlatformStatus), SolderType.INJECT);
        components.platformMonitorWiring().getOutputWire().solderTo("ExecutionStatusHandler", "status updates", execution::newPlatformStatus);
        components.platformMonitorWiring().getOutputWire().solderTo(components.gossipWiring().getPlatformStatusInput(), SolderType.INJECT);
        PlatformWiring.solderNotifier(components);
        if (callbacks.preconsensusEventConsumer() != null) {
            splitOrphanBufferOutput.solderTo("preConsensusEventCallback", "pre-consensus events", callbacks.preconsensusEventConsumer());
        }
        PlatformWiring.buildUnsolderedWires(components);
    }

    private static void solderEventWindow(PlatformComponents components) {
        OutputWire eventWindowOutputWire = components.eventWindowManagerWiring().getOutputWire();
        eventWindowOutputWire.solderTo(components.eventDeduplicatorWiring().getInputWire(EventDeduplicator::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.eventSignatureValidatorWiring().getInputWire(EventSignatureValidator::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.orphanBufferWiring().getInputWire(OrphanBuffer::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.gossipWiring().getEventWindowInput(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::updateNonAncientEventBoundary), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.eventCreationManagerWiring().getInputWire(EventCreatorModule::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.latestCompleteStateNexusWiring().getInputWire(LatestCompleteStateNexus::updateEventWindow));
        eventWindowOutputWire.solderTo(components.branchDetectorWiring().getInputWire(BranchDetector::updateEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.branchReporterWiring().getInputWire(BranchReporter::updateEventWindow), SolderType.INJECT);
    }

    private static void solderNotifier(PlatformComponents components) {
        components.latestCompleteStateNotifierWiring().getOutputWire().solderTo(components.notifierWiring().getInputWire(AppNotifier::sendLatestCompleteStateNotification));
        components.stateSnapshotManagerWiring().getTransformedOutput(StateSnapshotManager::toNotification).solderTo(components.notifierWiring().getInputWire(AppNotifier::sendStateWrittenToDiskNotification), SolderType.INJECT);
        OutputWire issNotificationOutputWire = components.issDetectorWiring().getSplitOutput();
        issNotificationOutputWire.solderTo(components.notifierWiring().getInputWire(AppNotifier::sendIssNotification));
        components.platformMonitorWiring().getOutputWire().solderTo(components.notifierWiring().getInputWire(AppNotifier::sendPlatformStatusChangeNotification));
    }

    private static void buildUnsolderedWires(PlatformComponents components) {
        components.eventDeduplicatorWiring().getInputWire(EventDeduplicator::clear);
        components.consensusEngineWiring().getInputWire(ConsensusEngine::outOfBandSnapshotUpdate);
        components.eventCreationManagerWiring().getInputWire(EventCreatorModule::clear);
        components.notifierWiring().getInputWire(AppNotifier::sendReconnectCompleteNotification);
        components.notifierWiring().getInputWire(AppNotifier::sendPlatformStatusChangeNotification);
        components.eventSignatureValidatorWiring().getInputWire(EventSignatureValidator::updateRosterHistory);
        components.eventWindowManagerWiring().getInputWire(EventWindowManager::updateEventWindow);
        components.orphanBufferWiring().getInputWire(OrphanBuffer::clear);
        components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::registerDiscontinuity);
        components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::clear);
        components.issDetectorWiring().getInputWire(IssDetector::overridingState);
        components.issDetectorWiring().getInputWire(IssDetector::signalEndOfPreconsensusReplay);
        components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::dumpStateTask);
        components.branchDetectorWiring().getInputWire(BranchDetector::clear);
        components.branchReporterWiring().getInputWire(BranchReporter::clear);
        components.platformMonitorWiring().getInputWire(PlatformMonitor::submitStatusAction);
        components.platformMonitorWiring().getInputWire(PlatformMonitor::quiescenceCommand);
        components.eventCreationManagerWiring().getInputWire(EventCreatorModule::quiescenceCommand);
    }
}

