/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.Signer;
import org.hiero.consensus.crypto.SigningFactory;
import org.hiero.consensus.crypto.SigningSchema;
import org.hiero.consensus.model.node.KeysAndCerts;

public class PlatformSigner
implements Signer,
BytesSigner {
    private final BytesSigner signer;
    private final SignatureType signatureType;

    public PlatformSigner(@NonNull KeysAndCerts keysAndCerts) {
        this.signer = SigningFactory.createSigner(keysAndCerts.sigKeyPair());
        SigningSchema schema = SigningSchema.fromKeyType(keysAndCerts.sigKeyPair().getPrivate());
        this.signatureType = switch (schema) {
            default -> throw new MatchException(null, null);
            case SigningSchema.RSA -> SignatureType.RSA;
            case SigningSchema.ED25519 -> SignatureType.ED25519;
        };
    }

    @NonNull
    public Signature sign(@NonNull byte[] data) {
        return new Signature(this.signatureType, this.sign(Bytes.wrap((byte[])data)));
    }

    @NonNull
    public Bytes sign(@NonNull Bytes data) {
        return this.signer.sign(data);
    }
}

