/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.crypto.SigningSchema;

public enum SigningImplementation {
    RSA_BC(SigningSchema.RSA, CryptoConstants.SIG_PROVIDER),
    RSA_JDK(SigningSchema.RSA, "SunRsaSign"),
    ED25519_SODIUM(SigningSchema.ED25519, "LibSodium"),
    ED25519_SUN(SigningSchema.ED25519, "SunEC");

    private final SigningSchema signingSchema;
    private final String provider;

    private SigningImplementation(SigningSchema signingSchema, String provider) {
        this.signingSchema = signingSchema;
        this.provider = provider;
    }

    @NonNull
    public SigningSchema getSigningSchema() {
        return this.signingSchema;
    }

    @NonNull
    public String getProvider() {
        return this.provider;
    }
}

