/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.orphan;

import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.orphan.OrphanedEvent;
import com.swirlds.platform.event.orphan.ParentAndOrphans;
import com.swirlds.platform.gossip.IntakeEventCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.NonDeterministicGeneration;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class DefaultOrphanBuffer
implements OrphanBuffer {
    private static final int INITIAL_CAPACITY = 1024;
    private static final Function<EventDescriptorWrapper, List<OrphanedEvent>> EMPTY_LIST = ignored -> new ArrayList();
    private EventWindow eventWindow;
    private int currentOrphanCount;
    private final IntakeEventCounter intakeEventCounter;
    private final SequenceMap<EventDescriptorWrapper, PlatformEvent> eventsWithParents;
    private final SequenceMap<EventDescriptorWrapper, List<OrphanedEvent>> missingParentMap;

    public DefaultOrphanBuffer(@NonNull Metrics metrics, @NonNull IntakeEventCounter intakeEventCounter) {
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.currentOrphanCount = 0;
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("platform", "orphanBufferSize", Integer.class, this::getCurrentOrphanCount).withDescription("number of orphaned events currently in the orphan buffer").withUnit("events"));
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.missingParentMap = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
        this.eventsWithParents = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
    }

    @Override
    @NonNull
    public List<PlatformEvent> handleEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
            return List.of();
        }
        ++this.currentOrphanCount;
        List<EventDescriptorWrapper> missingParents = this.getMissingParents(event);
        if (missingParents.isEmpty()) {
            return this.eventIsNotAnOrphan(event);
        }
        OrphanedEvent orphanedEvent = new OrphanedEvent(event, missingParents);
        for (EventDescriptorWrapper missingParent : missingParents) {
            ((List)this.missingParentMap.computeIfAbsent((Object)missingParent, EMPTY_LIST)).add(orphanedEvent);
        }
        return List.of();
    }

    @Override
    @NonNull
    public List<PlatformEvent> setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.eventsWithParents.shiftWindow(eventWindow.ancientThreshold());
        ArrayList ancientParents = new ArrayList();
        this.missingParentMap.shiftWindow(eventWindow.ancientThreshold(), (parent, orphans) -> ancientParents.add(new ParentAndOrphans((EventDescriptorWrapper)parent, (List<OrphanedEvent>)orphans)));
        ArrayList<PlatformEvent> unorphanedEvents = new ArrayList<PlatformEvent>();
        ancientParents.forEach(parentAndOrphans -> unorphanedEvents.addAll(this.missingParentBecameAncient((ParentAndOrphans)parentAndOrphans)));
        return unorphanedEvents;
    }

    @NonNull
    private List<PlatformEvent> missingParentBecameAncient(@NonNull ParentAndOrphans parentAndOrphans) {
        ArrayList<PlatformEvent> unorphanedEvents = new ArrayList<PlatformEvent>();
        EventDescriptorWrapper parentDescriptor = parentAndOrphans.parent();
        for (OrphanedEvent orphan : parentAndOrphans.orphans()) {
            orphan.missingParents().remove(parentDescriptor);
            if (!orphan.missingParents().isEmpty()) continue;
            unorphanedEvents.addAll(this.eventIsNotAnOrphan(orphan.orphan()));
        }
        return unorphanedEvents;
    }

    @NonNull
    private List<EventDescriptorWrapper> getMissingParents(@NonNull PlatformEvent event) {
        ArrayList<EventDescriptorWrapper> missingParents = new ArrayList<EventDescriptorWrapper>();
        for (EventDescriptorWrapper parent : event.getAllParents()) {
            if (this.eventsWithParents.containsKey((Object)parent) || this.eventWindow.isAncient(parent)) continue;
            missingParents.add(parent);
        }
        return missingParents;
    }

    @NonNull
    private List<PlatformEvent> eventIsNotAnOrphan(@NonNull PlatformEvent event) {
        ArrayList<PlatformEvent> unorphanedEvents = new ArrayList<PlatformEvent>();
        LinkedList<PlatformEvent> nonOrphanStack = new LinkedList<PlatformEvent>();
        nonOrphanStack.push(event);
        while (!nonOrphanStack.isEmpty()) {
            --this.currentOrphanCount;
            PlatformEvent nonOrphan = (PlatformEvent)nonOrphanStack.pop();
            EventDescriptorWrapper nonOrphanDescriptor = nonOrphan.getDescriptor();
            if (this.eventWindow.isAncient(nonOrphan)) {
                this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
                continue;
            }
            unorphanedEvents.add(nonOrphan);
            this.eventsWithParents.put((Object)nonOrphanDescriptor, (Object)nonOrphan);
            NonDeterministicGeneration.assignNGen((PlatformEvent)nonOrphan, this.eventsWithParents);
            List children = (List)this.missingParentMap.remove((Object)nonOrphanDescriptor);
            if (children == null) continue;
            for (OrphanedEvent child : children) {
                child.missingParents().remove(nonOrphanDescriptor);
                if (!child.missingParents().isEmpty()) continue;
                nonOrphanStack.push(child.orphan());
            }
        }
        return unorphanedEvents;
    }

    @NonNull
    Integer getCurrentOrphanCount() {
        return this.currentOrphanCount;
    }

    @Override
    public void clear() {
        this.eventsWithParents.clear();
        this.missingParentMap.clear();
        this.currentOrphanCount = 0;
    }
}

