/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics.event;

import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.stats.AverageAndMaxTimeStat;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class EventPipelineTracker {
    private final AverageAndMaxTimeStat hashing;
    private final AverageAndMaxTimeStat validation;
    private final AverageAndMaxTimeStat deduplication;
    private final AverageAndMaxTimeStat sigVerification;
    private final AverageAndMaxTimeStat orphanBuffer;
    private final AverageAndMaxTimeStat pces;
    private final AverageAndMaxTimeStat consensus;

    public EventPipelineTracker(@NonNull Metrics metrics) {
        int step = 1;
        this.hashing = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_hashing".formatted(step++), "event pipeline delay until after hashing");
        this.validation = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_validation".formatted(step++), "event pipeline delay until after validation");
        this.deduplication = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_deduplication".formatted(step++), "event pipeline delay until after deduplication");
        this.sigVerification = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_verification".formatted(step++), "event pipeline delay until after verification");
        this.orphanBuffer = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_orphanBuffer".formatted(step++), "event pipeline delay until after orphanBuffer");
        this.pces = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_pces".formatted(step++), "event pipeline delay until after pces");
        this.consensus = new AverageAndMaxTimeStat(metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_consensus".formatted(step++), "event pipeline delay until after consensus");
    }

    public void afterHashing(@NonNull PlatformEvent event) {
        this.hashing.update(event.getTimeReceived());
    }

    public void afterValidation(@NonNull PlatformEvent event) {
        this.validation.update(event.getTimeReceived());
    }

    public void afterDeduplication(@NonNull PlatformEvent event) {
        this.deduplication.update(event.getTimeReceived());
    }

    public void afterSigVerification(@NonNull PlatformEvent event) {
        this.sigVerification.update(event.getTimeReceived());
    }

    public void afterOrphanBuffer(@NonNull List<PlatformEvent> events) {
        for (PlatformEvent event : events) {
            this.orphanBuffer.update(event.getTimeReceived());
        }
    }

    public void afterPces(@NonNull PlatformEvent event) {
        this.pces.update(event.getTimeReceived());
    }

    public void afterConsensus(@NonNull ConsensusEngineOutput output) {
        for (ConsensusRound round : output.consensusRounds()) {
            for (PlatformEvent event : round.getConsensusEvents()) {
                this.consensus.update(event.getTimeReceived());
            }
        }
    }
}

