/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.netty;

import com.hedera.node.app.grpc.impl.netty.KnownLengthStream;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.MethodDescriptor;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

final class DataBufferMarshaller
implements MethodDescriptor.Marshaller<BufferedData> {
    private final int bufferCapacity;
    private final int tooBigMessageSize;
    private static final ThreadLocal<BufferedData> BUFFER_THREAD_LOCAL = new ThreadLocal();

    DataBufferMarshaller(int bufferCapacity, int maxMessageSize) {
        if (bufferCapacity < maxMessageSize) {
            throw new IllegalArgumentException("Buffer capacity must be greater than or equal to the maximum message size.");
        }
        this.bufferCapacity = bufferCapacity + 1;
        this.tooBigMessageSize = maxMessageSize + 1;
    }

    @NonNull
    public InputStream stream(@NonNull BufferedData buffer) {
        return new KnownLengthStream(buffer);
    }

    @NonNull
    public BufferedData parse(@NonNull InputStream stream) {
        Objects.requireNonNull(stream);
        BufferedData buffer = BUFFER_THREAD_LOCAL.get();
        if (buffer == null) {
            buffer = BufferedData.wrap((ByteBuffer)ByteBuffer.allocate(this.bufferCapacity));
            BUFFER_THREAD_LOCAL.set(buffer);
        }
        buffer.reset();
        buffer.writeBytes(stream, this.tooBigMessageSize);
        buffer.flip();
        return buffer;
    }
}

