/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.platform.gossip.shadowgraph.ShadowEvent;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.sync.SyncNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hiero.consensus.model.event.PlatformEvent;

public class SyncTestUtils {
    public static void printEvents(String heading, Collection<? extends EventImpl> events) {
        System.out.println("\n--- " + heading + " ---");
        events.forEach(System.out::println);
    }

    public static void printTasks(String heading, Collection<PlatformEvent> events) {
        System.out.println("\n--- " + heading + " ---");
        events.forEach(System.out::println);
    }

    public static void printTipSet(String nodeName, SyncNode node) {
        System.out.printf("\n--- %s's tipSet ---%n", nodeName);
        node.getShadowGraph().getTips().forEach(tip -> System.out.println(tip.getPlatformEvent()));
    }

    public static long getMaxIndicator(List<ShadowEvent> tips) {
        long maxIndicator = 1L;
        for (ShadowEvent tip : tips) {
            maxIndicator = Math.max(tip.getPlatformEvent().getBirthRound(), maxIndicator);
        }
        return maxIndicator;
    }

    public static long getMinIndicator(@NonNull Set<ShadowEvent> events) {
        long minIndicator = Long.MAX_VALUE;
        for (ShadowEvent event : events) {
            minIndicator = Math.min(event.getPlatformEvent().getBirthRound(), minIndicator);
        }
        return minIndicator == Long.MAX_VALUE ? 1L : minIndicator;
    }
}

