/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.internal.LinkedEvent;
import com.swirlds.platform.test.fixtures.event.DynamicValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public final class EventUtils {
    private EventUtils() {
    }

    public static byte[] serializePlatformEvent(@NonNull PlatformEvent event) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            new SerializableDataOutputStream((OutputStream)stream).writePbjRecord((Object)event.getGossipEvent(), GossipEvent.PROTOBUF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stream.toByteArray();
    }

    public static int weightedChoice(Random random, List<Double> weights) {
        double totalWeight = 0.0;
        for (Double weight : weights) {
            totalWeight += weight.doubleValue();
        }
        if (totalWeight <= 0.0) {
            throw new IllegalArgumentException("Total weight must be greater than 0.0.");
        }
        double randomValue = random.nextDouble() * totalWeight;
        double sum = 0.0;
        int choice = -1;
        for (int index = 0; index < weights.size(); ++index) {
            choice = index;
            if ((sum += weights.get(index).doubleValue()) > randomValue) break;
        }
        return choice;
    }

    public static boolean areBirthRoundNumbersValid(@NonNull Iterable<EventImpl> events, int numberOfNodes) {
        Objects.requireNonNull(events, "events must not be null");
        HashMap<NodeId, Long> previousBirthRound = new HashMap<NodeId, Long>(numberOfNodes);
        for (EventImpl event : events) {
            NodeId nodeId = event.getCreatorId();
            if (previousBirthRound.containsKey(nodeId) && (Long)previousBirthRound.get(nodeId) > event.getBirthRound()) {
                return false;
            }
            previousBirthRound.put(nodeId, event.getBirthRound());
        }
        return true;
    }

    public static boolean isEventOrderValid(List<EventImpl> events) {
        HashSet<EventImpl> eventsEncountered = new HashSet<EventImpl>();
        for (EventImpl event : events) {
            EventImpl selfParent = (EventImpl)event.getSelfParent();
            EventImpl otherParent = (EventImpl)event.getOtherParent();
            if (selfParent != null && !eventsEncountered.contains(selfParent)) {
                return false;
            }
            if (otherParent != null && !eventsEncountered.contains(otherParent)) {
                return false;
            }
            eventsEncountered.add(event);
        }
        return true;
    }

    public static List<EventImpl> sortEventList(List<EventImpl> events) {
        ArrayList<EventImpl> sortedEvents = new ArrayList<EventImpl>(events);
        sortedEvents.sort(Comparator.comparing(LinkedEvent::getBaseHash));
        return sortedEvents;
    }

    public static boolean areEventListsEquivalent(List<EventImpl> events1, List<EventImpl> events2) {
        events1 = EventUtils.sortEventList(events1);
        events2 = EventUtils.sortEventList(events2);
        return events1.equals(events2);
    }

    public static <T> DynamicValue<T> staticDynamicValue(T staticValue) {
        return (random, eventIndex, previousValue) -> staticValue;
    }

    public static DynamicValue<Integer> integerPowerDistribution(double alpha) {
        return (random, eventIndex, previousValue) -> {
            int ret = 0;
            while (random.nextDouble() > alpha) {
                ++ret;
            }
            return ret;
        };
    }

    public static DynamicValue<Integer> integerPowerDistribution(double alpha, int minimum) {
        return (random, eventIndex, previousValue) -> {
            int ret = 0;
            while (random.nextDouble() > alpha) {
                ++ret;
            }
            return Integer.max(ret, minimum);
        };
    }

    private static int calculateOtherParentAge(List<EventImpl> events, int eventIndex) {
        EventImpl nextEvent;
        EventImpl event = events.get(eventIndex);
        EventImpl otherParent = (EventImpl)event.getOtherParent();
        if (otherParent == null) {
            return 0;
        }
        NodeId otherParentNode = otherParent.getCreatorId();
        int age = 0;
        for (int index = eventIndex - 1; index >= 0 && (nextEvent = events.get(index)) != otherParent; --index) {
            if (!Objects.equals(nextEvent.getCreatorId(), otherParentNode)) continue;
            ++age;
        }
        return age;
    }

    public static Map<Integer, Integer> gatherOtherParentAges(List<EventImpl> events, Set<NodeId> excludedNodes) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int eventIndex = 0; eventIndex < events.size(); ++eventIndex) {
            if (excludedNodes != null && excludedNodes.contains(events.get(eventIndex).getCreatorId())) continue;
            int age = EventUtils.calculateOtherParentAge(events, eventIndex);
            if (!map.containsKey(age)) {
                map.put(age, 0);
            }
            map.put(age, (Integer)map.get(age) + 1);
        }
        return map;
    }
}

