/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;

public final class Randotron
extends Random {
    private final long seed;

    public static Randotron create() {
        long seed = new Random().nextLong();
        System.out.println("Random seed: " + seed + "L");
        return new Randotron(seed);
    }

    public static Randotron create(long seed) {
        return new Randotron(seed);
    }

    private Randotron(long seed) {
        super(seed);
        this.seed = seed;
    }

    public Randotron copyAndReset() {
        return new Randotron(this.seed);
    }

    @NonNull
    public String nextString(int length) {
        int LEFT_LIMIT = 48;
        int RIGHT_LIMIT = 122;
        return this.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @NonNull
    public String nextIp() {
        return this.nextInt(256) + "." + this.nextInt(256) + "." + this.nextInt(256) + "." + this.nextInt(256);
    }

    public long nextPositiveLong(long maxValue) {
        return this.longs(1L, 1L, maxValue).findFirst().orElseThrow();
    }

    public long nextPositiveLong() {
        return this.nextPositiveLong(Long.MAX_VALUE);
    }

    public int nextPositiveInt(int maxValue) {
        return this.ints(1L, 1, maxValue).findFirst().orElseThrow();
    }

    public int nextPositiveInt() {
        return this.nextPositiveInt(Integer.MAX_VALUE);
    }

    @NonNull
    public Hash nextHash() {
        return new Hash(this.nextByteArray(DigestType.SHA_384.digestLength()), DigestType.SHA_384);
    }

    @NonNull
    public Bytes nextHashBytes() {
        return Bytes.wrap((byte[])this.nextByteArray(DigestType.SHA_384.digestLength()));
    }

    @NonNull
    public Signature nextSignature() {
        return new Signature(SignatureType.RSA, this.nextByteArray(SignatureType.RSA.signatureLength()));
    }

    @NonNull
    public Bytes nextSignatureBytes() {
        return Bytes.wrap((byte[])this.nextByteArray(SignatureType.RSA.signatureLength()));
    }

    @NonNull
    public byte[] nextByteArray(int size) {
        byte[] bytes = new byte[size];
        this.nextBytes(bytes);
        return bytes;
    }

    @NonNull
    public Instant nextInstant() {
        return Instant.ofEpochMilli(this.nextPositiveLong(2000000000000L));
    }

    @NonNull
    public Duration nextDuration(@NonNull Duration maxDuration) {
        if (maxDuration.isNegative() || maxDuration.isZero()) {
            throw new IllegalArgumentException("maxDuration must be positive");
        }
        return Duration.ofNanos(this.nextPositiveLong(maxDuration.toNanos()));
    }

    @NonNull
    public Duration nextDuration(@NonNull Duration minDuration, @NonNull Duration maxDuration) {
        if (minDuration.isNegative() || minDuration.isZero()) {
            throw new IllegalArgumentException("minDuration must be positive");
        }
        if (maxDuration.isNegative() || maxDuration.isZero()) {
            throw new IllegalArgumentException("maxDuration must be positive");
        }
        if (minDuration.compareTo(maxDuration) > 0) {
            throw new IllegalArgumentException("minDuration must not be greater than maxDuration");
        }
        long deltaNanos = maxDuration.toNanos() - minDuration.toNanos();
        return deltaNanos == 0L ? minDuration : Duration.ofNanos(minDuration.toNanos() + this.nextPositiveLong(deltaNanos + 1L));
    }

    public boolean nextBoolean(double trueProbability) {
        if (trueProbability < 0.0 || trueProbability > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0 and 1");
        }
        return this.nextDouble() < trueProbability;
    }

    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return "Randotron{" + this.seed + "L}";
    }
}

