/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.wires.output;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.transformers.AdvancedTransformation;
import com.swirlds.component.framework.transformers.WireFilter;
import com.swirlds.component.framework.transformers.WireListSplitter;
import com.swirlds.component.framework.transformers.WireTransformer;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.internal.TransformingOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class OutputWire<OUT> {
    private final TraceableWiringModel model;
    private final String name;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public OutputWire(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.model = Objects.requireNonNull(model);
        this.name = Objects.requireNonNull(name);
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    protected TraceableWiringModel getModel() {
        return this.model;
    }

    @NonNull
    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void solderTo(@NonNull InputWire<OUT> inputWire) {
        this.solderTo(inputWire, SolderType.PUT);
    }

    public void orderedSolderTo(@NonNull List<InputWire<OUT>> inputWires) {
        if (inputWires.size() < 2) {
            throw new IllegalArgumentException("List must contain at least 2 input wires.");
        }
        inputWires.forEach(this::solderTo);
    }

    public void solderTo(@NonNull InputWire<OUT> inputWire, @NonNull SolderType solderType) {
        if (inputWire.getTaskSchedulerType() == TaskSchedulerType.NO_OP) {
            return;
        }
        this.model.registerEdge(this.name, inputWire.getTaskSchedulerName(), inputWire.getName(), solderType);
        switch (solderType) {
            case PUT: {
                this.addForwardingDestination(inputWire::put);
                break;
            }
            case INJECT: {
                this.addForwardingDestination(inputWire::inject);
                break;
            }
            case OFFER: {
                this.addForwardingDestination(inputWire::offer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown solder type: " + String.valueOf((Object)solderType));
            }
        }
    }

    public void solderForMonitoring(@NonNull Consumer<OUT> consumer) {
        this.addForwardingDestination(consumer);
    }

    public void solderTo(@NonNull String handlerName, @NonNull String inputWireLabel, @NonNull Consumer<OUT> handler) {
        TaskScheduler directScheduler = this.model.schedulerBuilder(handlerName).withType(TaskSchedulerType.DIRECT).build();
        BindableInputWire directSchedulerInputWire = directScheduler.buildInputWire(inputWireLabel);
        directSchedulerInputWire.bindConsumer(handler);
        this.solderTo(directSchedulerInputWire);
    }

    @NonNull
    public OutputWire<OUT> buildFilter(@NonNull String filterName, @NonNull String filterInputName, @NonNull Predicate<OUT> predicate) {
        Objects.requireNonNull(filterName);
        Objects.requireNonNull(filterInputName);
        Objects.requireNonNull(predicate);
        WireFilter<OUT> filter = new WireFilter<OUT>(this.model, filterName, filterInputName, predicate);
        this.solderTo(filter.getInputWire());
        return filter.getOutputWire();
    }

    @NonNull
    public <ELEMENT> OutputWire<ELEMENT> buildSplitter(@NonNull String splitterName, @NonNull String splitterInputName) {
        Objects.requireNonNull(splitterName);
        Objects.requireNonNull(splitterInputName);
        WireListSplitter splitter = new WireListSplitter(this.model, splitterName, splitterInputName);
        this.solderTo(splitter.getInputWire());
        return splitter.getOutputWire();
    }

    @NonNull
    public <NEW_OUT> OutputWire<NEW_OUT> buildTransformer(@NonNull String transformerName, @NonNull String transformerInputName, @NonNull Function<OUT, NEW_OUT> transformer) {
        Objects.requireNonNull(transformerName);
        Objects.requireNonNull(transformerInputName);
        Objects.requireNonNull(transformer);
        WireTransformer<OUT, NEW_OUT> wireTransformer = new WireTransformer<OUT, NEW_OUT>(this.model, transformerName, transformerInputName, transformer);
        this.solderTo(wireTransformer.getInputWire());
        return wireTransformer.getOutputWire();
    }

    @NonNull
    public <NEW_OUT> OutputWire<NEW_OUT> buildAdvancedTransformer(@NonNull AdvancedTransformation<OUT, NEW_OUT> transformer) {
        TransformingOutputWire<Object, Object> outputWire = new TransformingOutputWire<Object, Object>(this.model, transformer.getTransformerName(), this.getUncaughtExceptionHandler(), transformer::transform, transformer::inputCleanup, transformer::outputCleanup);
        this.solderTo(transformer.getTransformerName(), transformer.getTransformerInputName(), outputWire::forward);
        return outputWire;
    }

    protected abstract void addForwardingDestination(@NonNull Consumer<OUT> var1);
}

