/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.platform.state.PlatformStateModifier;
import com.swirlds.state.State;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.hiero.base.crypto.test.fixtures.CryptoRandomUtils;
import org.hiero.base.utility.CommonUtils;
import org.hiero.base.utility.test.fixtures.RandomUtils;

public final class PlatformStateUtils {
    private PlatformStateUtils() {
    }

    public static PlatformStateModifier randomPlatformState(State state) {
        return PlatformStateUtils.randomPlatformState(new Random(), state);
    }

    public static PlatformStateModifier randomPlatformState(Random random, State state) {
        com.swirlds.platform.state.service.PlatformStateUtils.bulkUpdateOf((State)state, v -> {
            v.setLegacyRunningEventHash(CryptoRandomUtils.randomHash((Random)random));
            v.setRound(random.nextLong());
            v.setConsensusTimestamp(RandomUtils.randomInstant((Random)random));
            v.setCreationSoftwareVersion(SemanticVersion.newBuilder().major(RandomUtils.nextInt((int)1, (int)100)).build());
        });
        LinkedList<MinimumJudgeInfo> minimumJudgeInfo = new LinkedList<MinimumJudgeInfo>();
        for (int index = 0; index < 10; ++index) {
            minimumJudgeInfo.add(new MinimumJudgeInfo(random.nextLong(), random.nextLong()));
        }
        List<JudgeId> judges = Arrays.asList(new JudgeId(0L, CryptoRandomUtils.randomHashBytes((Random)random)), new JudgeId(1L, CryptoRandomUtils.randomHashBytes((Random)random)), new JudgeId(2L, CryptoRandomUtils.randomHashBytes((Random)random)));
        com.swirlds.platform.state.service.PlatformStateUtils.setSnapshotTo((State)state, (ConsensusSnapshot)ConsensusSnapshot.newBuilder().round(random.nextLong()).judgeIds(judges).minimumJudgeInfoList(minimumJudgeInfo).nextConsensusNumber(random.nextLong()).consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)RandomUtils.randomInstant((Random)random))).build());
        return com.swirlds.platform.state.service.PlatformStateUtils.getWritablePlatformStateOf((State)state);
    }
}

