/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractCreateTransactionBodyJsonCodec
implements JsonCodec<ContractCreateTransactionBody> {
    public static final OneOf<ContractCreateTransactionBody.InitcodeSourceOneOfType> INITCODE_SOURCE_UNSET = new OneOf((Enum)ContractCreateTransactionBody.InitcodeSourceOneOfType.UNSET, null);
    public static final OneOf<ContractCreateTransactionBody.StakedIdOneOfType> STAKED_ID_UNSET = new OneOf((Enum)ContractCreateTransactionBody.StakedIdOneOfType.UNSET, null);

    @NonNull
    public ContractCreateTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            OneOf temp_initcodeSource = INITCODE_SOURCE_UNSET;
            Key temp_adminKey = null;
            long temp_gas = 0L;
            long temp_initialBalance = 0L;
            AccountID temp_proxyAccountID = null;
            Duration temp_autoRenewPeriod = null;
            Bytes temp_constructorParameters = Bytes.EMPTY;
            ShardID temp_shardID = null;
            RealmID temp_realmID = null;
            Key temp_newRealmAdminKey = null;
            String temp_memo = "";
            int temp_max_automatic_token_associations = 0;
            AccountID temp_auto_renew_account_id = null;
            OneOf temp_staked_id = STAKED_ID_UNSET;
            boolean temp_decline_reward = false;
            List temp_hook_creation_details = Collections.emptyList();
            block42: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "fileID": {
                        temp_initcodeSource = new OneOf((Enum)ContractCreateTransactionBody.InitcodeSourceOneOfType.FILE_ID, FileID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block42;
                    }
                    case "initcode": {
                        temp_initcodeSource = new OneOf((Enum)ContractCreateTransactionBody.InitcodeSourceOneOfType.INITCODE, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"initcode", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block42;
                    }
                    case "adminKey": {
                        temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "gas": {
                        temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block42;
                    }
                    case "initialBalance": {
                        temp_initialBalance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block42;
                    }
                    case "proxyAccountID": {
                        temp_proxyAccountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "autoRenewPeriod": {
                        temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "constructorParameters": {
                        temp_constructorParameters = Bytes.fromBase64((String)JsonTools.checkSize((String)"constructorParameters", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block42;
                    }
                    case "shardID": {
                        temp_shardID = (ShardID)ShardID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "realmID": {
                        temp_realmID = (RealmID)RealmID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "newRealmAdminKey": {
                        temp_newRealmAdminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)JsonTools.checkSize((String)"memo", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block42;
                    }
                    case "maxAutomaticTokenAssociations": {
                        temp_max_automatic_token_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block42;
                    }
                    case "autoRenewAccountId": {
                        temp_auto_renew_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block42;
                    }
                    case "stakedAccountId": {
                        temp_staked_id = new OneOf((Enum)ContractCreateTransactionBody.StakedIdOneOfType.STAKED_ACCOUNT_ID, AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block42;
                    }
                    case "stakedNodeId": {
                        temp_staked_id = new OneOf((Enum)ContractCreateTransactionBody.StakedIdOneOfType.STAKED_NODE_ID, (Object)JsonTools.parseLong((JSONParser.ValueContext)kvPair.value()));
                        continue block42;
                    }
                    case "declineReward": {
                        temp_decline_reward = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block42;
                    }
                    case "hookCreationDetails": {
                        temp_hook_creation_details = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"hook_creation_details", (List)kvPair.value().arr().value(), (int)maxSize), HookCreationDetails.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block42;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractCreateTransactionBody(temp_initcodeSource, temp_adminKey, temp_gas, temp_initialBalance, temp_proxyAccountID, temp_autoRenewPeriod, temp_constructorParameters, temp_shardID, temp_realmID, temp_newRealmAdminKey, temp_memo, temp_max_automatic_token_associations, temp_auto_renew_account_id, temp_staked_id, temp_decline_reward, temp_hook_creation_details);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractCreateTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.initcodeSource().kind() == ContractCreateTransactionBody.InitcodeSourceOneOfType.FILE_ID) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"fileID", FileID.JSON, (Object)data.fileID()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.initialBalance() != 0L) {
            fieldLines.add(JsonTools.field((String)"initialBalance", (long)data.initialBalance()));
        }
        if (data.proxyAccountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"proxyAccountID", AccountID.JSON, (Object)data.proxyAccountID()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (data.constructorParameters() != Bytes.EMPTY && data.constructorParameters() != null && data.constructorParameters().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"constructorParameters", (Bytes)data.constructorParameters()));
        }
        if (data.shardID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"shardID", ShardID.JSON, (Object)data.shardID()));
        }
        if (data.realmID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"realmID", RealmID.JSON, (Object)data.realmID()));
        }
        if (data.newRealmAdminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"newRealmAdminKey", Key.JSON, (Object)data.newRealmAdminKey()));
        }
        if (data.memo() != null && !data.memo().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.maxAutomaticTokenAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"maxAutomaticTokenAssociations", (int)data.maxAutomaticTokenAssociations()));
        }
        if (data.autoRenewAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccountId", AccountID.JSON, (Object)data.autoRenewAccountId()));
        }
        if (data.initcodeSource().kind() == ContractCreateTransactionBody.InitcodeSourceOneOfType.INITCODE) {
            fieldLines.add(JsonTools.field((String)"initcode", (Bytes)data.initcode()));
        }
        if (data.stakedId().kind() == ContractCreateTransactionBody.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"stakedAccountId", AccountID.JSON, (Object)data.stakedAccountId()));
        }
        if (data.stakedId().kind() == ContractCreateTransactionBody.StakedIdOneOfType.STAKED_NODE_ID) {
            fieldLines.add(JsonTools.field((String)"stakedNodeId", (long)data.stakedNodeId()));
        }
        if (data.declineReward()) {
            fieldLines.add(JsonTools.field((String)"declineReward", (boolean)data.declineReward()));
        }
        if (!data.hookCreationDetails().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"hookCreationDetails", HookCreationDetails.JSON, data.hookCreationDetails()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

