/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto.internal;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.hiero.base.crypto.BytesSignatureVerifier;
import org.hiero.base.crypto.CryptographyException;

public class JcaVerifier
implements BytesSignatureVerifier {
    private final Signature verifier;

    public JcaVerifier(@NonNull PublicKey publicKey, @NonNull String algorithm, @NonNull String provider) {
        try {
            this.verifier = Signature.getInstance(algorithm, provider);
            this.verifier.initVerify(publicKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptographyException((Throwable)e);
        }
    }

    public boolean verify(@NonNull Bytes data, @NonNull Bytes signature) {
        try {
            data.updateSignature(this.verifier);
            return signature.verifySignature(this.verifier);
        }
        catch (SignatureException e) {
            throw new CryptographyException((Throwable)e);
        }
    }
}

