/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import java.util.LinkedList;

public class Http2Flag {
    public static final int END_OF_STREAM = 1;
    public static final int ACK = 1;
    public static final int END_OF_HEADERS = 4;
    public static final int PADDED = 8;
    public static final int PRIORITY = 32;
    private final int value;

    Http2Flag(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return this.value == 0 ? "" : String.valueOf(this.value);
    }

    private static boolean isSet(int flag, int value) {
        return (value & flag) != 0;
    }

    public static class NoFlags
    extends Http2Flag {
        private static final NoFlags EMPTY = new NoFlags(0);

        private NoFlags(int flags) {
            super(flags);
        }

        public static NoFlags create() {
            return EMPTY;
        }

        public static NoFlags create(int flags) {
            return new NoFlags(flags);
        }
    }

    public static class ContinuationFlags
    extends Http2Flag
    implements EndOfHeaders {
        private ContinuationFlags(int value) {
            super(value);
        }

        public static ContinuationFlags create(int flags) {
            return new ContinuationFlags(flags & 4);
        }

        @Override
        public String toString() {
            return this.endOfHeaders() ? "END_HEADERS" : "";
        }
    }

    public static class PingFlags
    extends Http2Flag
    implements Ack {
        private PingFlags(int value) {
            super(value);
        }

        public static PingFlags create(int flags) {
            return new PingFlags(flags);
        }
    }

    public static class PushPromiseFlags
    extends Http2Flag
    implements EndOfHeaders,
    Padded {
        private PushPromiseFlags(int value) {
            super(value);
        }

        public static PushPromiseFlags create(int flags) {
            return new PushPromiseFlags(flags);
        }
    }

    public static class SettingsFlags
    extends Http2Flag
    implements Ack {
        private SettingsFlags(int value) {
            super(value);
        }

        public static SettingsFlags create(int flags) {
            return new SettingsFlags(flags & 1);
        }

        @Override
        public String toString() {
            return this.ack() ? "ACK" : "";
        }
    }

    public static class DataFlags
    extends Http2Flag
    implements EndOfStream,
    Padded {
        private DataFlags(int value) {
            super(value);
        }

        public static DataFlags create(int flags) {
            return new DataFlags(flags);
        }

        @Override
        public String toString() {
            LinkedList<String> activeFlags = new LinkedList<String>();
            if (this.endOfStream()) {
                activeFlags.add("END_STREAM");
            }
            if (this.padded()) {
                activeFlags.add("PADDED");
            }
            return String.join((CharSequence)", ", activeFlags);
        }
    }

    public static class HeaderFlags
    extends Http2Flag
    implements EndOfStream,
    EndOfHeaders,
    Priority,
    Padded {
        private HeaderFlags(int value) {
            super(value);
        }

        public static HeaderFlags create(int flags) {
            return new HeaderFlags(flags & 0x2D);
        }

        @Override
        public String toString() {
            LinkedList<String> activeFlags = new LinkedList<String>();
            if (this.endOfStream()) {
                activeFlags.add("END_STREAM");
            }
            if (this.endOfHeaders()) {
                activeFlags.add("END_HEADERS");
            }
            if (this.priority()) {
                activeFlags.add("PRIORITY");
            }
            if (this.padded()) {
                activeFlags.add("PADDED");
            }
            return String.join((CharSequence)", ", activeFlags);
        }
    }

    static interface EndOfStream
    extends Flags {
        default public boolean endOfStream() {
            return Http2Flag.isSet(1, this.value());
        }
    }

    static interface EndOfHeaders
    extends Flags {
        default public boolean endOfHeaders() {
            return Http2Flag.isSet(4, this.value());
        }
    }

    static interface Priority
    extends Flags {
        default public boolean priority() {
            return Http2Flag.isSet(32, this.value());
        }
    }

    static interface Ack
    extends Flags {
        default public boolean ack() {
            return Http2Flag.isSet(1, this.value());
        }
    }

    static interface Padded
    extends Flags {
        default public boolean padded() {
            return Http2Flag.isSet(8, this.value());
        }
    }

    public static interface Flags {
        public int value();
    }
}

