/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Settings;

public record Http2RstStream(Http2ErrorCode errorCode) implements Http2Frame<Http2Flag.NoFlags>
{
    public static Http2RstStream create(BufferData bufferData) {
        return new Http2RstStream(Http2ErrorCode.get(bufferData.readInt32()));
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.NoFlags flags) {
        BufferData data = BufferData.create((int)4);
        data.writeInt32(this.errorCode.code());
        Http2FrameHeader header = Http2FrameHeader.create(4, this.frameTypes(), flags, streamId);
        return new Http2FrameData(header, data);
    }

    @Override
    public String name() {
        return Http2FrameType.RST_STREAM.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.RST_STREAM;
    }

    @Override
    public Http2FrameTypes<Http2Flag.NoFlags> frameTypes() {
        return Http2FrameTypes.RST_STREAM;
    }
}

